<!doctype html>
<html lang="en">
  <head>
    <meta charset="UTF-8" />
    <link rel="icon" type="image/svg+xml" href="/vite.svg" />
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400;500;600;700&family=Noto+Serif:wght@400;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <link rel="stylesheet" href="style.css?v=<?php echo time(); ?>" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <!-- Add Splide.js CSS and JS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@splidejs/splide@4.1.4/dist/css/splide.min.css">
    <script src="https://cdn.jsdelivr.net/npm/@splidejs/splide@4.1.4/dist/js/splide.min.js"></script>
    <title>The American Club - Private Members Club</title>
  </head>
  <body>
    <!-- Header -->
    <button class="nav-toggle" aria-label="Toggle Navigation">
      <span class="hamburger-line"></span>
      <span class="hamburger-line"></span>
      <span class="hamburger-line"></span>
    </button>
    <button class="nav-close" aria-label="Close Navigation">
    </button>
    <div class="logo">  
      <!-- <h1>THE AMERICAN CLUB</h1>
      <span>SINGAPORE</span> -->
      <a href="/tac/"><img src="/tac/images/tac-logo.webp" alt="The American Club Logo" class="logo-img"></a>
    </div>
    <div class="header-right">
      <a href="/tac/login.php" class="member-link">Member</a>
      <span class="divider">|</span>
      <a class="search-toggle">Search <i class="fa-solid fa-magnifying-glass"></i></a>
    </div>
    <!-- Fullscreen Navigation Menu -->
    <div class="fullscreen-nav">
      <div class="nav-content">
        <div class="nav-header">
        </div>
        <div class="nav-split">
          <div class="overlay-menu-left">
            <div class="main-nav">
              <ul>
                <li class="nav-parent">
                  <span class="roman-num">I</span>
                  <a href="#home">About Us</a>
                </li>
                <li class="nav-parent has-children">
                  <span class="roman-num">II</span>
                  <a class="parent" data-child="services">Services</a>
                </li>
                <li class="nav-parent has-children">
                  <span class="roman-num">III</span>
                  <a class="parent" data-child="events">News & Events</a>
                </li>
                <li class="nav-parent has-children">
                  <span class="roman-num">IV</span>
                  <a class="parent" data-child="media">Media</a>
                </li>
                <li class="nav-parent">
                  <span class="roman-num">V</span>
                  <a href="#">Contact Us</a>
                </li>
                <li class="nav-parent">
                  <span class="roman-num">VI</span>
                  <a href="#">Shop</a>
                </li>
              </ul>
            </div>
            <div class="nav-children" data-parent="services">
              <a href="#" class="main-child">More about services<i class="fa-solid fa-chevron-right"></i></a>
              <div class="sub-children">
                <a href="#">Wine & Dine</a>
                <a href="#">Fitness & Leisure</a>
                <a href="#">Youth & Family</a>
                <a href="#">Club Services</a>
                <a href="#">Member Services</a>
              </div>
            </div>
            <div class="nav-children" data-parent="events">
              <a href="#" class="main-child">More about events<i class="fa-solid fa-chevron-right"></i></a>
              <div class="sub-children">
                <a href="#">For companies</a>
                <a href="#">Weddings and celebrations</a>
              </div>
            </div>
            <div class="nav-children" data-parent="media">
              <a href="#" class="main-child">Important information<i class="fa-solid fa-chevron-right"></i></a>
              <div class="sub-children">
                <a href="#">Loyalty program</a>
                <a href="#">We think ecologically</a>
                <a href="#">Dual education</a>
                <a href="#">General contract terms</a>
              </div>
            </div>
          </div>
          <div class="nav-contact">
            <div class="contact-content">
              <a href="/tac/"><img src="/tac/images/tac-logo.webp" alt="The American Club Logo" class="logo-img"></a>
              <div class="contact-details">
                <h2>The American Club</h2>
                <p class="address">10 Claymore Hill<br>Singapore, 229573</p>
                <div class="contact-info">
                  <p class="contact-phone">+65 6737 3411</p>
                  <p class="contact-email">info@amclub.org.sg</p>
                </div>
              </div>
              <div class="social-links">
                <a href="#" aria-label="Facebook"><i class="fab fa-facebook"></i></a>
                <a href="#" aria-label="Instagram"><i class="fab fa-instagram"></i></a>
                <a href="#" aria-label="LinkedIn"><i class="fab fa-linkedin"></i></a>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <!-- Hero Banner Section -->
    <section class="banner" id="hero">
      <div class="banner-slider">
        <div class="banner-slide active">
          <img src="/tac/images/home/banner/home-hero-01.webp" alt="Banner Image 1">
        </div>
        <div class="banner-slide">
          <img src="/tac/images/home/banner/home-hero-02.webp" alt="Banner Image 2">
        </div>
        <div class="banner-slide">
          <img src="/tac/images/home/banner/home-hero-03.webp" alt="Banner Image 3">
        </div>
        <div class="banner-slide">
          <img src="/tac/images/home/banner/home-hero-04.webp" alt="Banner Image 4">
        </div>
        <div class="banner-slide">
          <img src="/tac/images/home/banner/home-hero-05.webp" alt="Banner Image 5">
        </div>
        <div class="banner-slide">
          <img src="/tac/images/home/banner/home-hero-06.webp" alt="Banner Image 6">
        </div>
      </div>
      <div class="banner-content">
        <div class="banner-overlay"></div>
        <div class="banner-text">
          <p>Welcome to The American Club. Exclusively Yours</p>
          <h1>More Than a Club.<br>A Place to Call Home.</h1>
          <a href="/tac/membership.php" class="cta-button secondary">Get to Know Us</a>
        </div>
      </div>
      <button class="scroll-down-btn" aria-label="Scroll to next section">
        <i class="fa-solid fa-chevron-down"></i>
      </button>
    </section>

    <!-- Text Section 1 -->
    <section class="text-section text-section-1">
      <div class="container">
          <h4>WELCOME</h4>
        <div class="content-wrapper">
          <h1 class="section-title">Discover Your Private Escape in the City</h1>
          <p class="section-body">The American Club offers a steady sense of community and purpose. With world-class facilities and heartfelt service, we bring a warm, welcoming spirit to life in a relaxed retreat where families and individuals can connect, unwind and feel at home.</p>
          <a href="/tac/membership.php" class="cta-button primary">BECOME A MEMBER</a>
        </div>
      </div>
    </section>

    <!-- Services Section -->
    <section class="services-section" id="services">
      <div class="container">
        <h2 class="section-title">American Club Services</h2>
        <div class="splide services-splide">
          <div class="splide__track">
            <ul class="splide__list">
              <li class="splide__slide">
                <div class="service-card">
                  <div class="service-image">
                    <img src="/tac/images/home/services/wine-and-dine.webp" alt="Wine and Dining">
                  </div>
                  <div class="service-content">
                    <h3>Wine & Dine</h3>
                    <p>Go on a culinary journey that blends global flavours across a variety of upscale dining values.</p>
                    <a href="#" class="cta-button primary">Learn More</a>
                  </div>
                </div>
              </li>
              <li class="splide__slide">
                <div class="service-card">
                  <div class="service-image">
                    <img src="/tac/images/home/services/fitness-and-leisure.webp" alt="Fitness & Leisure">
                  </div>
                  <div class="service-content">
                    <h3>Fitness & Leisure</h3>
                    <p>State-of-the-art facilities, group classes, personal training, and tranquil retreats all designed to keep you active, energised, and well.</p>
                    <a href="#" class="cta-button primary">Learn More</a>
                  </div>
                </div>
              </li>
              <li class="splide__slide">
                <div class="service-card">
                  <div class="service-image">
                    <img src="/tac/images/home/services/youth-and-family.webp" alt="Youth & Family">
                  </div>
                  <div class="service-content">
                    <h3>Youth & Family</h3>
                    <p>Spaces and programs for every age with family-first activities, camps, and educational fun all year round, so everyone feels at home.</p>
                    <a href="#" class="cta-button primary">Learn More</a>
                  </div>
                </div>
              </li>
              <li class="splide__slide">
                <div class="service-card">
                  <div class="service-image">
                    <img src="/tac/images/home/services/club-services.webp" alt="Club Services">
                  </div>
                  <div class="service-content">
                    <h3>Club Services</h3>
                    <p>Everything you need, without ever leaving. Whether you're working, relaxing, or simply living, The Club is designed around you.</p>
                    <a href="#" class="cta-button primary">Learn More</a>
                  </div>
                </div>
              </li>
              <li class="splide__slide">
                <div class="service-card">
                  <div class="service-image">
                    <img src="/tac/images/home/services/member-services.webp" alt="Member Services">
                  </div>
                  <div class="service-content">
                    <h3>Member Services</h3>
                    <p>From an attentive concierge service to our expert membership team, We're here to welcome you seamlessly into The American Club.</p>
                    <a href="#" class="cta-button primary">Learn More</a>
                  </div>
                </div>
              </li>
            </ul>
          </div>
        </div>
      </div>
    </section>

    <!-- Events Section -->
    <section class="events-section" id="events">
      <div class="container">
        <div class="events-wrapper">
          <div class="events-content">
            <h2 class="section-title">Stay In The Know</h2>
            <p class="section-body">Exclusive member events, themed evenings, and family days. If it's happening at The American Club, you won't want to miss it.</p>
            <a href="#" class="cta-button secondary">View the full calendar</a>
            <div class="card-nav">
              <button class="nav-btn prev" aria-label="Previous event">
                <i class="fas fa-chevron-left"></i>
              </button>
              <button class="nav-btn next" aria-label="Next event">
                <i class="fas fa-chevron-right"></i>
              </button>
            </div>
          </div>
          <div class="stack">
            <div class="card">
              <div class="events-image">
                <img src="/tac/images/home/events/tradewinds.png">
              </div>
              <div class="events-info">
                <img src="/tac/images/home/brands/tradewinds.png">
                <h3>Asian Delight Brunch</h3>
                <span class="event-time">July - September, 2025</span>
                <p>This Father's Day, raise a glass to Dad with bold cocktails and hearty dishes crafted for the occasion.</p>
                <a href="#" class="cta-button primary">Learn More</a>
              </div>
            </div>
            <div class="card">
              <div class="events-image">
                <img src="/tac/images/home/events/the2ndfloor.png">
              </div>
              <div class="events-info">
                <img src="/tac/images/home/brands/the-2nd-floor-logo.png">
                <h3>Indulge in Romance</h3>
                <span class="event-time">July - Sep tember, 2025</span>
                <p>Large, artfully composed images of food and drinks, framed with thin gold borders or gold abstract lines, enhance the ambiance without overpowering it.</p>
                <a href="#" class="cta-button primary">Learn More</a>
              </div>
            </div>
            <div class="card">
              <div class="events-image">
                <img src="/tac/images/home/events/grillhouse.png">
              </div>
              <div class="events-info">
                <img src="/tac/images/home/brands/grillhouse-logo.png">
                <h3>Always Fresh Off the Grill</h3>
                <span class="event-time">July - September, 2025</span>
                <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam,</p>
                <a href="#" class="cta-button primary">Learn More</a>
              </div>
            </div>
            <div class="card">
              <div class="events-image">
                <img src="/tac/images/home/events/thegourmetpantry.png">
              </div>
              <div class="events-info">
                <img src="/tac/images/home/brands/the-gourmet-pantry-logo.png">
                <h3>Cheese Selection</h3>
                <span class="event-time">July - September, 2025</span>
                <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam,</p>
                <a href="#" class="cta-button primary">Learn More</a>
              </div>
            </div>
            <div class="card">  
              <div class="events-image">
                <img src="/tac/images/home/events/central.png">
              </div>
              <div class="events-info">
                <img src="/tac/images/home/brands/central-logo.png">
                <h3>Cream Burlee Latte</h3>
                <span class="event-time">July - September, 2025</span>
                <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam,</p>
                <a href="#" class="cta-button primary">Learn More</a>
              </div>
            </div>
            <div class="card">  
              <div class="events-image">
                <img src="/tac/images/home/events/senspa.png">
              </div>
              <div class="events-info">
                <img src="/tac/images/home/brands/senspa-logo.png">
                <h3>Glow Up Your Skin</h3>
                <span class="event-time">July - September, 2025</span>
                <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam,</p>
                <a href="#" class="cta-button primary">Learn More</a>
              </div>
            </div>
            <div class="card">  
              <div class="events-image">
                <img src="/tac/images/home/events/thequad.png">
              </div>
              <div class="events-info">
                <img src="/tac/images/home/brands/thequad-logo.png">
                <h3>Asian Delight Brunch</h3>
                <span class="event-time">July - September, 2025</span>
                <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam,</p>
                <a href="#" class="cta-button primary">Learn More</a>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>

    <!-- Text Section 1 -->
    <section class="text-section text-section-2">
      <div class="container">
        <div class="content-wrapper">
          <h1 class="section-title">Not Just A Club, Your Community</h1>
          <p class="section-body">Being part of The American Club means more than access. It means connection. To people, to culture and to moments that matter.</p>
        </div>
      </div>
    </section>

    <!-- Features Section -->
    <section class="features-section">
      <div class="container">
        <div class="features-grid">
          <div class="feature-card why-members">
            <div class="feature-content">
              <h3 class="section-title">See Why Members Call It Home</h3>
              <p class="section-body">From world-class facilities to the warmth of our people, The American Club is designed to feel like home, yet unlike anywhere else.</p>
              <a href="#" class="cta-button secondary">Book A Tour</a>
            </div>
          </div>
          <div class="feature-card business-office">
            <div class="feature-content">
              <h3 class="section-title">Business & Office Spaces</h3>
              <p class="section-body">From focused solo work to client presentations, our business spaces provide everything you need with polished facilities and a calm space to get things done.</p>
              <a href="#" class="cta-button secondary">Learn More</a>
            </div>
          </div>
          <div class="feature-card home-family">
            <div class="feature-content">
              <h3 class="section-title">Home for the Whole Family</h3>
              <p class="section-body">With programmes, facilities, and experiences that bring the whole family together, The American Club is where cherished moments take root.</p>
              <a href="#" class="cta-button secondary">Learn More</a>
            </div>
          </div>
        </div>
      </div>
    </section>

    <!-- Footer -->
    <footer class="footer">
      <div class="container">
        <div class="footer-content-wrapper footer-row-1">
          <div class="footer-content footer-left">
            <div class="footer-section">
              <h4>ABOUT US</h4>
              <ul>
                <li><a href="#">Club Governance</a></li>
                <li><a href="#">Club Constitution</a></li>
              </ul>
            </div>
            <div class="footer-section">
              <h4>SERVICES</h4>
              <ul>
                <li><a href="#">Wine & Dine</a></li>
                <li><a href="#">Fitness & Leisure</a></li>
                <li><a href="#">Youth & Family</a></li>
                <li><a href="#">Club Services</a></li>
                <li><a href="#">Member Services</a></li>
                <li><a href="#">Business</a></li>
              </ul>
            </div>
            <div class="footer-section">
              <h4>NEWS & EVENTS</h4>
              <ul>
                <li><a href="#">News Updates</a></li>
                <li><a href="#">Events</a></li>
                <li><a href="#">Calendar</a></li>
              </ul>
            </div>
            <div class="footer-section">
              <h4>MEDIA</h4>
              <ul>
                <li><a href="#">Gallery</a></li>
                <li><a href="#">Publications</a></li>
              </ul>
            </div>
            <div class="footer-section">
              <h4>CONTACT US</h4>
              <ul>
                <li><a href="#">Career</a></li>
                <li><a href="#">Partner with us</a></li>
                <li><a href="#">Membership</a></li>
              </ul>
            </div>
            <div class="footer-section">
              <h4>SHOP</h4>
            </div>
          </div>
          <div class="footer-content footer-right">
            <img src="/tac/images/tac-logo.webp" alt="The American Club Logo">
            <p>10 Claymore Hill Singapore, 229573</p>
            <p>+65 6737 3411</p>
            <p>info@amclub.org.sg</p>
          </div>
        </div>
        <div class="footer-content-wrapper footer-row-2">
          <p>Subscribe to our newsletter for the latest updates</p>
          <a href="#" class="cta-button secondary">Subscribe</a>
        </div>
        <div class="footer-content-wrapper footer-row-3">
          <div class="social-links">
            <a href="#" aria-label="Facebook"><i class="fab fa-facebook"></i></a>
            <a href="#" aria-label="Instagram"><i class="fab fa-instagram"></i></a>
            <a href="#" aria-label="LinkedIn"><i class="fab fa-linkedin"></i></a>
            <a href="#" aria-label="WhatsApp"><i class="fab fa-whatsapp"></i></a>
          </div>
        </div>
        <div class="footer-content-wrapper footer-row-4">
          <p>&copy; 2025 The American Club Singapore. All rights reserved.</p>
          <div class="footer-row-4-right">
            <a href="#">Privacy Policy</a>
            <a href="#">Terms of Use</a>
            <a href="#">Cookies Policy</a>
            <a href="#">Legal Notice</a>
          </div>
        </div>
      </div>
    </footer>

    <script type="module" src="/tac/main.js?v=<?php echo time(); ?>"></script>
    <!-- Glide.js -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@glidejs/glide@3.6.0/dist/css/glide.core.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@glidejs/glide@3.6.0/dist/css/glide.theme.min.css">
    <script src="https://cdn.jsdelivr.net/npm/@glidejs/glide@3.6.0/dist/glide.min.js"></script>
  </body>
</html>