<!doctype html>
<html lang="en">
  <head>
    <meta charset="UTF-8" />
    <link rel="icon" type="image/svg+xml" href="/vite.svg" />
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400;500;600;700&family=Noto+Serif:wght@400;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <link rel="stylesheet" href="style.css?v=<?php echo time(); ?>" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>The American Club - Member Login</title>
  </head>
  <body class="login">
    <!-- Header -->
    <button class="nav-toggle" aria-label="Toggle Navigation">
        <span class="hamburger-line"></span>
        <span class="hamburger-line"></span>
        <span class="hamburger-line"></span>
    </button>
    <button class="nav-close" aria-label="Close Navigation">
    </button>
    <div class="logo">
    <!-- <h1>THE AMERICAN CLUB</h1>
    <span>SINGAPORE</span> -->
    <a href="/tac/"><img src="/tac/images/tac-logo.webp" alt="The American Club Logo" class="logo-img"></a>
    </div>
    <div class="header-right">
    <a href="/tac/login.html" class="member-link">Member</a>
    <span class="divider">|</span>
    <a class="search-toggle">Search <i class="fa-solid fa-magnifying-glass"></i></a>
    </div>
    
    <!-- Fullscreen Navigation Menu -->
    <div class="fullscreen-nav">
      <div class="nav-content">
        <div class="nav-header">
        </div>
        <div class="nav-split">
          <div class="overlay-menu-left">
            <div class="main-nav">
              <ul>
                <li class="nav-parent">
                  <span class="roman-num">I</span>
                  <a href="/">About Us</a>
                </li>
                <li class="nav-parent has-children">
                  <span class="roman-num">II</span>
                  <a class="parent" data-child="services">Services</a>
                </li>
                <li class="nav-parent has-children">
                  <span class="roman-num">III</span>
                  <a class="parent" data-child="events">News & Events</a>
                </li>
                <li class="nav-parent has-children">
                  <span class="roman-num">IV</span>
                  <a class="parent" data-child="media">Media</a>
                </li>
                <li class="nav-parent">
                  <span class="roman-num">V</span>
                  <a href="#">Contact Us</a>
                </li>
                <li class="nav-parent">
                  <span class="roman-num">VI</span>
                  <a href="#">Shop</a>
                </li>
              </ul>
            </div>
            <div class="nav-children" data-parent="services">
              <a href="#" class="main-child">More about services<i class="fa-solid fa-chevron-right"></i></a>
              <div class="sub-children">
                <a href="#">Wine & Dine</a>
                <a href="#">Fitness & Leisure</a>
                <a href="#">Youth & Family</a>
                <a href="#">Club Services</a>
                <a href="#">Member Services</a>
              </div>
            </div>
            <div class="nav-children" data-parent="events">
              <a href="#" class="main-child">More about events<i class="fa-solid fa-chevron-right"></i></a>
              <div class="sub-children">
                <a href="#">For companies</a>
                <a href="#">Weddings and celebrations</a>
              </div>
            </div>
            <div class="nav-children" data-parent="media">
              <a href="#" class="main-child">Important information<i class="fa-solid fa-chevron-right"></i></a>
              <div class="sub-children">
                <a href="#">Loyalty program</a>
                <a href="#">We think ecologically</a>
                <a href="#">Dual education</a>
                <a href="#">General contract terms</a>
              </div>
            </div>
          </div>
          <div class="nav-contact">
            <div class="contact-content">
              <a href="/tac/"><img src="/tac/images/tac-logo.webp" alt="The American Club Logo" class="logo-img"></a>
              <div class="contact-details">
                <h2>The American Club</h2>
                <p class="address">10 Claymore Hill<br>Singapore, 229573</p>
                <div class="contact-info">
                  <p class="contact-phone">+65 6737 3411</p>
                  <p class="contact-email">info@amclub.org.sg</p>
                </div>
              </div>
              <div class="social-links">
                <a href="#" aria-label="Facebook"><i class="fab fa-facebook"></i></a>
                <a href="#" aria-label="Instagram"><i class="fab fa-instagram"></i></a>
                <a href="#" aria-label="LinkedIn"><i class="fab fa-linkedin"></i></a>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <section class="login-section">
        <div class="container">
            <div class="login-wrapper">
                <div class="login-content">
                    <h1 class="section-title">Club Access Login</h1>
                    <form class="login-form" method="POST">
                        <div class="form-group">
                            <label for="username">Email</label>
                            <input type="text" id="username" name="username" required>
                        </div>
                        <div class="form-group">
                            <label for="password">Password</label>
                            <input type="password" id="password" name="password" required>
                            <a href="#" class="form-links forget-password">Forget Password?</a>
                        </div>
                        <button type="submit" class="cta-button secondary">Sign In</button>
                        <a href="#" class="form-links create-account">Create an Account</a>
                    </form>
                </div>
            </div>
        </div>
    </section>

        <!-- Footer -->
        <footer class="footer">
          <div class="container">
            <div class="footer-content-wrapper footer-row-1">
              <div class="footer-content footer-left">
                <div class="footer-section">
                  <h4>ABOUT US</h4>
                  <ul>
                    <li><a href="#">Club Governance</a></li>
                    <li><a href="#">Club Constitution</a></li>
                  </ul>
                </div>
                <div class="footer-section">
                  <h4>SERVICES</h4>
                  <ul>
                    <li><a href="#">Wine & Dine</a></li>
                    <li><a href="#">Fitness & Leisure</a></li>
                    <li><a href="#">Youth & Family</a></li>
                    <li><a href="#">Club Services</a></li>
                    <li><a href="#">Member Services</a></li>
                    <li><a href="#">Business</a></li>
                  </ul>
                </div>
                <div class="footer-section">
                  <h4>NEWS & EVENTS</h4>
                  <ul>
                    <li><a href="#">News Updates</a></li>
                    <li><a href="#">Events</a></li>
                    <li><a href="#">Calendar</a></li>
                  </ul>
                </div>
                <div class="footer-section">
                  <h4>MEDIA</h4>
                  <ul>
                    <li><a href="#">Gallery</a></li>
                    <li><a href="#">Publications</a></li>
                  </ul>
                </div>
                <div class="footer-section">
                  <h4>CONTACT US</h4>
                  <ul>
                    <li><a href="#">Career</a></li>
                    <li><a href="#">Partner with us</a></li>
                    <li><a href="#">Membership</a></li>
                  </ul>
                </div>
                <div class="footer-section">
                  <h4>SHOP</h4>
                </div>
              </div>
              <div class="footer-content footer-right">
                <img src="/tac/images/tac-logo.webp" alt="The American Club Logo">
                <p>10 Claymore Hill Singapore, 229573</p>
                <p>+65 6737 3411</p>
                <p>info@amclub.org.sg</p>
              </div>
            </div>
            <div class="footer-content-wrapper footer-row-2">
              <p>Subscribe to our newsletter for the latest updates</p>
              <a href="#" class="cta-button secondary">Subscribe</a>
            </div>
            <div class="footer-content-wrapper footer-row-3">
              <div class="social-links">
                <a href="#" aria-label="Facebook"><i class="fab fa-facebook"></i></a>
                <a href="#" aria-label="Instagram"><i class="fab fa-instagram"></i></a>
                <a href="#" aria-label="LinkedIn"><i class="fab fa-linkedin"></i></a>
                <a href="#" aria-label="WhatsApp"><i class="fab fa-whatsapp"></i></a>
              </div>
            </div>
            <div class="footer-content-wrapper footer-row-4">
              <p>&copy; 2025 The American Club Singapore. All rights reserved.</p>
              <div class="footer-row-4-right">
                <a href="#">Privacy Policy</a>
                <a href="#">Terms of Use</a>
                <a href="#">Cookies Policy</a>
                <a href="#">Legal Notice</a>
              </div>
            </div>
          </div>
        </footer>

    <script type="module" src="/tac/main.js?v=<?php echo time(); ?>"></script>
  </body>
</html>
