document.addEventListener('DOMContentLoaded', function () {
	const body = document.body;
	const header = document.querySelector('.top-header');
	const navToggle = document.querySelector('.nav-toggle');
	const navClose = document.querySelector('.nav-close');
	const fullscreenNav = document.querySelector('.fullscreen-nav');

	let lastScrollY = window.scrollY;

	function updateSticky() {
		if (window.scrollY > 20) {
			body.classList.add('scrolled');
			header && header.classList.add('sticky');
		} else {
			body.classList.remove('scrolled');
			header && header.classList.remove('sticky');
		}
	}

	updateSticky();
	window.addEventListener('scroll', updateSticky, { passive: true });

	// Mobile header hide/show disabled to keep sticky visible
	// (kept simple: no header-hidden toggling)
	// window.addEventListener('scroll', () => {}, { passive: true });

	// Menu open/close
	function openMenu() {
		fullscreenNav && fullscreenNav.classList.add('active');
		body.classList.add('menu-active');
		navClose && navClose.classList.add('active');
	}
	function closeMenu() {
		fullscreenNav && fullscreenNav.classList.remove('active');
		body.classList.remove('menu-active');
		navClose && navClose.classList.remove('active');
	}

	navToggle && navToggle.addEventListener('click', openMenu);
	navClose && navClose.addEventListener('click', closeMenu);

	// Close menu when clicking outside left panel
	fullscreenNav && fullscreenNav.addEventListener('click', (e) => {
		if (e.target.classList.contains('fullscreen-nav')) {
			closeMenu();
		}
	});
}); 