<!doctype html>
<html lang="en">
  <!-- Head -->
  <?php include 'head.php'; ?>
  
  <body class="home">
    <!-- Header -->
    <?php include 'header.php'; ?>

    <!-- Hero Banner Section -->
    <section class="video-lepas" id="hero">
      <div class="video-lepas-content-lepas">
        <video autoplay muted playsinline>
          <source src="/lepas/videos/lepas-video.mp4" type="video/mp4">
          <source src="https://staging.020.my/lepas/videos/lepas-home.webm" type="video/webm">
          Your browser does not support the video tag.
        </video>

        <div class="video-overlay-text">
          <h2>COLOURFUL LIFE,<br>MASTERFUL DRIVE</h2>
          <a href="#" class="video-btn"><i class="fa-solid fa-chevron-right"></i></a>
        </div>
      </div>
    </section>

    <section class="leopard-section" id="leopard-section">
      <div class="leopard-background"></div>
      <div class="leopard-overlay"></div>
      <div class="leopard__content">
        <img src="/lepas/images/lepas_image/home_page/car-white-copy.png" class="car-image" alt="LEPAS Car" onerror="this.style.display='none'; console.log('Car image failed to load');">
        <div class="content-leopard">
          <h2>EXPERIENCE THE ART OF COLORFUL LIVING</h2>
          <p class="leopard__desc">
            At LEPAS, mobility is more than motion—it's an expression. We create not just vehicles,
            but a richer way of moving through the world, alive with colour, detail, and desire.
            LEPAS cars embody natural power and refined sophistication, blending natural beauty with modern life.
          </p>
        </div>
      </div>

    </section>

    <section class="three-model-section">
      <div class="three-model-grid">
        <div class="three-model-card l4-model">
          <div class="model-background">
            <img src="/lepas/images/lepas_image/home_page/l4-banner.webp" alt="L4 Background">
          </div>
          <div class="model-video">
            <video muted playsinline loop preload="metadata">
              <source src="/lepas/videos/lepas-video.mp4" type="video/mp4">
              <source src="https://staging.020.my/lepas/videos/lepas-home.webm" type="video/webm">
            </video>
          </div>
          <div class="model-content">
            <h2>L4</h2>
            <p>For the urban adventurer.</p>
            <a href="/lepas/model.html" class="cta-button secondary">DISCOVER</a>
          </div>
          <div class="model-car">
            <img src="/lepas/images/lepas_image/home_page/Layer-L4-center.webp" alt="L4 Car Model">
          </div>
        </div>

        <div class="three-model-card l8-model">
          <div class="model-background">
            <img src="/lepas/images/lepas_image/home_page/l8-banner.webp" alt="L8 Background">
          </div>
          <div class="model-video">
            <video muted playsinline loop preload="metadata">
              <source src="/lepas/videos/lepas-video.mp4" type="video/mp4">
              <source src="https://staging.020.my/lepas/videos/lepas-home.webm" type="video/webm">
            </video>
          </div>
          <div class="model-content">
            <h2>L8</h2>
            <p>For leaders of the road.</p>
            <a href="/lepas/model.html" class="cta-button primary">DISCOVER</a>
          </div>
          <div class="model-car">
            <img src="/lepas/images/lepas_image/home_page/Layer-L8-center.webp" alt="L8 Car Model">
          </div>
        </div>

        <div class="three-model-card l6-model">
          <div class="model-background">
            <img src="/lepas/images/lepas_image/home_page/l6-banner.webp" alt="L6 Background">
          </div>
          <div class="model-video">
            <video muted playsinline loop preload="metadata">
              <source src="/lepas/videos/lepas-video.mp4" type="video/mp4">
              <source src="https://staging.020.my/lepas/videos/lepas-home.webm" type="video/webm">
            </video>
          </div>
          <div class="model-content">
            <h2>L6</h2>
            <p>For the discerning modern driver.</p>
            <a href="/lepas/model.html" class="cta-button secondary">DISCOVER</a>
          </div>
          <div class="model-car">
            <img src="/lepas/images/lepas_image/home_page/Layer-L6-center.webp" alt="L6 Car Model">
          </div>
        </div>
      </div>
    </section>

    <!-- Sculpted From Nature Section -->
    <section class="sculpted-nature-section">
      <div class="container">
        <div class="sculpted-content">
          <h2 data-aos="fade-up" data-aos-duration="1200" data-aos-delay="300">SCULPTED FROM NATURE</h2>
          <p data-aos="fade-up" data-aos-duration="1200" data-aos-delay="600">Inspired by the agility and grace of the leopard, LEPAS cars are sculpted for dynamic presence. With vibrant hues and elegant design, each model reflects a harmony of performance, beauty, and intelligence, made for drivers who crave design rooted in natural beauty, and performance rooted in modern innovation.</p>
        </div>
      </div>
    </section>

    <section class="luxury-carousel" aria-label="Luxury in Motion">
  <div class="lux-carousel" id="luxuryCarousel">
    <!-- arrows -->
    <button class="arrow prev" aria-label="Previous"></button>

    <div class="viewport">
      <div class="track">
        <!-- Slide 2 -->
        <article class="lux-slide"
          style="--img:url('/lepas/images/lepas_image/home_page/gallery-2.webp')">
          <div class="media"></div>
          <div class="content">
            <h3 class="title">Immersive Multi-Screen Cabin</h3>
            <div class="cta"><a class="btn" href="#">Learn more</a></div>
          </div>
        </article>

        <!-- Slide 1 -->
        <article class="lux-slide is-active"
          style="--img:url('/lepas/images/lepas_image/home_page/gallery-1.webp')">
          <div class="media"></div>
          <div class="content">
            <h3 class="title">LUXURY IN MOTION</h3>
            <div class="cta"><a class="btn" href="#">Learn more</a></div>
          </div>
        </article>

        <!-- Slide 3 -->
        <article class="lux-slide"
          style="--img:url('/lepas/images/lepas_image/home_page/gallery-3.webp')">
          <div class="media"></div>
          <div class="content">
            <h3 class="title">Executive Lounge Seating</h3>
            <div class="cta"><a class="btn" href="#">Learn more</a></div>
          </div>
        </article>
      </div>
    </div>

    <button class="arrow next" aria-label="Next"></button>

    <div class="dots" aria-hidden="true"></div>
  </div>
</section>




    <!-- Two Column Hover Section -->
    <section class="two-column-hover-section">
      <div class="container">
        <div class="hover-column left-column">
          <div class="column-background">
            <img src="/lepas/images/lepas_image/home_page/dearlership.webp" alt="dealership" onerror="this.style.display='none'; this.parentElement.style.backgroundColor='#2c3e50';">
          </div>
          <div class="hover-overlay">
            <img src="/lepas/images/lepas_image/home_page/hover-gradient.webp" alt="Hover Overlay" onerror="this.style.display='none';">
          </div>
          <div class="column-content">
            <h2>LOCATE A DEALERSHIP</h2>
            <a href="#" class="cta-button secondary">Discover</a>
          </div>
        </div>
        <div class="hover-column right-column">
          <div class="column-background">
            <img src="/lepas/images/lepas_image/home_page/aftersales.webp" alt="aftersales" onerror="this.style.display='none'; this.parentElement.style.backgroundColor='#34495e';">
          </div>
          <div class="hover-overlay">
            <img src="/lepas/images/lepas_image/home_page/hover-gradient.webp" alt="Hover Overlay" onerror="this.style.display='none';">
          </div>
          <div class="column-content">
            <h2>LEPAS AFTERSALES</h2>
            <a href="#" class="cta-button secondary">LEARN MORE</a>
          </div>
        </div>
      </div>
    </section>

    <!-- Sticky Bottom Right Element -->
    <div class="sticky-bottom-right">
      <div class="sticky-icons">
        <a href="#" class="sticky-icon">
          <img src="/lepas/images/lepas_image/home_page/location.png" alt="Location">
        </a>
        <a href="#" class="sticky-icon">
          <img src="/lepas/images/lepas_image/home_page/calculator.png" alt="Calculator">
        </a>
        <a href="#" class="sticky-icon">
          <img src="/lepas/images/lepas_image/home_page/email.png" alt="Email">
        </a>
      </div>
      <a href="#" class="test-drive-button">TEST DRIVE</a>
    </div>

    <!-- Footer -->
    <?php include 'footer.php'; ?>



  </body>
</html>