<!doctype html>
<html lang="en">
  <!-- Head -->
  <?php include 'head.php'; ?>
  
  <body class="membership">
    <!-- Header -->
    <?php include 'header.php'; ?>

    <!-- Hero Banner Section -->
    <section class="banner" id="hero">
      <div class="banner-slider">
        <div class="banner-slide active">
          <img src="/tac/images/membership/banner/membership-banner-01.png" alt="Banner Image 1">
        </div>
        <div class="banner-slide">
          <img src="/tac/images/membership/banner/membership-banner-02.png" alt="Banner Image 2">
        </div>
      </div>
      <div class="banner-content">
        <div class="banner-text">
          <p>Join the American Club</p>
          <h1>Explore Your Path to Membership</h1>
          <a href="#" class="cta-button secondary">Join Us</a>
        </div>
      </div>
      <button class="scroll-down-btn" aria-label="Scroll to next section">
        <i class="fa-solid fa-chevron-down"></i>
      </button>
    </section>

    <!-- Text Section 1 -->
    <section class="text-section text-section-1">
      <div class="container">
        <div class="content-wrapper">
          <h1 class="section-title" data-aos="fade-right" data-aos-duration="1000">A Membership<br>That Matches Your Life</h1>
          <p class="section-body" data-aos="fade-up" data-aos-duration="1000" data-aos-delay="100">Your reasons for joining are uniquely yours. That’s why we offer thoughtfully curated membership categories so you can choose how you experience The American Club, and who you bring with you.</p>
        </div>
      </div>
    </section>

    <!-- Features Section -->
    <section class="features-section">
      <div class="container">
        <div class="features-grid">
          <div class="feature-card club">
            <div class="feature-content">
              <h3 class="section-title">See Why Members Call It Home</h3>
              <p class="section-body">Wherever your travels take you, your membership travels with you. With access to prestigious Reciprocal Clubs around the world, you’ll always be welcomed like family, no matter the city or the continent.</p>
              <a href="#" class="cta-button secondary">Learn More</a>
            </div>
          </div>
          <div class="feature-card niche">
            <div class="feature-content">
              <h3 class="section-title">Niche Group Membership</h3>
              <p class="section-body">The Niche Group Membership celebrates those who’ve made The American Club a lasting part of their lives. With exclusive tiers based on tenure or spending, it’s our way of saying thank you.</p>
              <a href="#" class="cta-button secondary">Learn More</a>
            </div>
          </div>
          <div class="feature-card supplementary">
            <div class="feature-content">
              <h3 class="section-title">Supplementary Membership Categories</h3>
              <p class="section-body">We understand that home includes more than your immediate household. Apply for a Supplementary Membership card for your parents, children, or long-term guests, and share The Club with those who matter most.</p>
              <a href="#" class="cta-button secondary">Learn More</a>
            </div>
          </div>
          <div class="feature-card refer">
            <div class="feature-content">
              <h3 class="section-title">Refer a Friend</h3>
              <p class="section-body">Share The American Club lifestyle with those you value most. Introduce a friend and be rewarded* with Club dining vouchers, because good taste should always be shared.</p>
              <a href="#" class="cta-button secondary">Learn More</a>
            </div>
          </div>
        </div>
      </div>
    </section>

    <!-- Banner Section -->
    <section class="banner-normal" id="tour">
        <div class="banner-content">
            <div class="banner-text">
                <h1>Virtual Club Tour</h1>
                <p class="section-body">Take a digital stroll through our vibrant dining, fitness, and community spaces.</p>
                <a href="#" class="cta-button secondary">Learn More</a>
            </div>
        </div>
    </section>

    <!-- Banner Section -->
    <section class="banner-normal" id="joining-fees">
        <div class="banner-slider">
            <div class="banner-slide active">
                <img src="/tac/images/membership/joining-fees-bg-01.png" alt="Joining Fees">
            </div>
        </div>
        <div class="banner-content">
            <div class="banner-text">
                <h1>Joining Fees</h1>
                <p class="section-body">The American Club offers multiple pathways to membership. Explore our joining fees and see how you can become part of something truly special.</p>
                <div class="banner-buttons">
                    <a href="#" class="cta-button primary">Start Your Application</a>
                    <a href="#" class="cta-button primary">View More</a>
                </div>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <?php include 'footer.php'; ?>

  </body>
</html>