// Standalone Slick Carousel Fix
(function() {
    'use strict';
    
    // Wait for everything to load
    function initSlickCarousel() {
        console.log('🔧 Initializing Slick carousel...');
        
        // Check if jQuery is available
        if (typeof jQuery === 'undefined') {
            console.log('❌ jQuery not found, loading...');
            loadScript('https://code.jquery.com/jquery-3.6.0.min.js', function() {
                loadSlick();
            });
            return;
        }
        
        // Check if Slick is available
        if (typeof jQuery.fn.slick === 'undefined') {
            console.log('❌ Slick not found, loading...');
            loadSlick();
            return;
        }
        
        // Initialize the carousel
        initializeCarousel();
    }
    
    function loadSlick() {
        // Load Slick CSS
        if (!document.querySelector('link[href*="slick.css"]')) {
            const slickCSS = document.createElement('link');
            slickCSS.rel = 'stylesheet';
            slickCSS.type = 'text/css';
            slickCSS.href = 'https://cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick.css';
            document.head.appendChild(slickCSS);
        }
        
        // Load Slick theme CSS
        if (!document.querySelector('link[href*="slick-theme.css"]')) {
            const slickThemeCSS = document.createElement('link');
            slickThemeCSS.rel = 'stylesheet';
            slickThemeCSS.type = 'text/css';
            slickThemeCSS.href = 'https://cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick-theme.css';
            document.head.appendChild(slickThemeCSS);
        }
        
        // Load Slick JS
        loadScript('https://cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick.min.js', function() {
            setTimeout(initializeCarousel, 100);
        });
    }
    
    function loadScript(src, callback) {
        const script = document.createElement('script');
        script.src = src;
        script.onload = callback;
        script.onerror = function() {
            console.log('❌ Failed to load:', src);
        };
        document.head.appendChild(script);
    }
    
    function initializeCarousel() {
        const carousel = document.querySelector('.luxury-carousel-slick');
        if (!carousel) {
            console.log('❌ Carousel element not found');
            return;
        }
        
        console.log('✅ Found carousel element');
        
        // Check if already initialized
        if (jQuery(carousel).hasClass('slick-initialized')) {
            console.log('🔄 Carousel already initialized, destroying...');
            jQuery(carousel).slick('unslick');
        }
        
        // Initialize Slick - Static carousel with full width slides
        jQuery(carousel).slick({
            centerMode: false,
            slidesToShow: 1,
            slidesToScroll: 1,
            arrows: true,
            dots: false,
            infinite: true,
            autoplay: false,
            responsive: [
                {
                    breakpoint: 768,
                    settings: {
                        centerMode: false,
                        slidesToShow: 1
                    }
                },
                {
                    breakpoint: 480,
                    settings: {
                        centerMode: false,
                        slidesToShow: 1
                    }
                }
            ]
        });
        
        console.log('✅ Slick carousel initialized successfully!');
        
        // Force arrow visibility and styling
        setTimeout(function() {
            const arrows = carousel.querySelectorAll('.slick-arrow');
            arrows.forEach(function(arrow) {
                arrow.style.display = 'block';
                arrow.style.opacity = '1';
                arrow.style.visibility = 'visible';
                arrow.style.zIndex = '1000';
                arrow.style.background = 'rgba(255, 255, 255, 0.2)';
                arrow.style.border = '2px solid rgba(255, 255, 255, 0.5)';
                arrow.style.boxShadow = '0 4px 12px rgba(0, 0, 0, 0.3)';
                arrow.style.position = 'absolute';
                arrow.style.bottom = '20px';
                arrow.style.width = '60px';
                arrow.style.height = '60px';
                arrow.style.borderRadius = '50%';
                arrow.style.cursor = 'pointer';
            });
            
            // Position arrows specifically
            const prevArrow = carousel.querySelector('.slick-prev');
            const nextArrow = carousel.querySelector('.slick-next');
            
            if (prevArrow) {
                prevArrow.style.left = '50%';
                prevArrow.style.transform = 'translateX(-80px)';
            }
            
            if (nextArrow) {
                nextArrow.style.right = '50%';
                nextArrow.style.transform = 'translateX(80px)';
            }
            
            console.log('✅ Arrows styled and visible');
        }, 500);
    }
    
    // Start initialization when DOM is ready
    if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', initSlickCarousel);
    } else {
        initSlickCarousel();
    }
    
    // Also try after a delay as backup
    setTimeout(initSlickCarousel, 2000);
    
})(); 