<!doctype html>
<html lang="en">
  <head>
    <meta charset="UTF-8" />
    <link rel="icon" type="image/svg+xml" href="/vite.svg" />
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400;500;600;700&family=Noto+Serif:wght@400;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <link rel="stylesheet" href="style.css?v=<?php echo time(); ?>" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <!-- Add Splide.js CSS and JS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@splidejs/splide@4.1.4/dist/css/splide.min.css">
    <script src="https://cdn.jsdelivr.net/npm/@splidejs/splide@4.1.4/dist/js/splide.min.js"></script>
    <title>The American Club - Private Members Club</title>
  </head>
  <body class="membership">
    <!-- Header -->
    <button class="nav-toggle" aria-label="Toggle Navigation">
      <span class="hamburger-line"></span>
      <span class="hamburger-line"></span>
      <span class="hamburger-line"></span>
    </button>
    <button class="nav-close" aria-label="Close Navigation">
    </button>
    <div class="logo">  
      <!-- <h1>THE AMERICAN CLUB</h1>
      <span>SINGAPORE</span> -->
      <a href="/tac/"><img src="/tac/images/tac-logo.webp" alt="The American Club Logo" class="logo-img"></a>
    </div>
    <div class="header-right">
      <a href="/tac/login.html" class="member-link">Member</a>
      <span class="divider">|</span>
      <a class="search-toggle">Search <i class="fa-solid fa-magnifying-glass"></i></a>
    </div>
    <!-- Fullscreen Navigation Menu -->
    <div class="fullscreen-nav">
      <div class="nav-content">
        <div class="nav-header">
        </div>
        <div class="nav-split">
          <div class="overlay-menu-left">
            <div class="main-nav">
              <ul>
                <li class="nav-parent">
                  <span class="roman-num">I</span>
                  <a href="#home">About Us</a>
                </li>
                <li class="nav-parent has-children">
                  <span class="roman-num">II</span>
                  <a class="parent" data-child="services">Services</a>
                </li>
                <li class="nav-parent has-children">
                  <span class="roman-num">III</span>
                  <a class="parent" data-child="events">News & Events</a>
                </li>
                <li class="nav-parent has-children">
                  <span class="roman-num">IV</span>
                  <a class="parent" data-child="media">Media</a>
                </li>
                <li class="nav-parent">
                  <span class="roman-num">V</span>
                  <a href="#">Contact Us</a>
                </li>
                <li class="nav-parent">
                  <span class="roman-num">VI</span>
                  <a href="#">Shop</a>
                </li>
              </ul>
            </div>
            <div class="nav-children" data-parent="services">
              <a href="#" class="main-child">More about services<i class="fa-solid fa-chevron-right"></i></a>
              <div class="sub-children">
                <a href="#">Wine & Dine</a>
                <a href="#">Fitness & Leisure</a>
                <a href="#">Youth & Family</a>
                <a href="#">Club Services</a>
                <a href="#">Member Services</a>
              </div>
            </div>
            <div class="nav-children" data-parent="events">
              <a href="#" class="main-child">More about events<i class="fa-solid fa-chevron-right"></i></a>
              <div class="sub-children">
                <a href="#">For companies</a>
                <a href="#">Weddings and celebrations</a>
              </div>
            </div>
            <div class="nav-children" data-parent="media">
              <a href="#" class="main-child">Important information<i class="fa-solid fa-chevron-right"></i></a>
              <div class="sub-children">
                <a href="#">Loyalty program</a>
                <a href="#">We think ecologically</a>
                <a href="#">Dual education</a>
                <a href="#">General contract terms</a>
              </div>
            </div>
          </div>
          <div class="nav-contact">
            <div class="contact-content">
              <a href="/tac/"><img src="/tac/images/tac-logo.webp" alt="The American Club Logo" class="logo-img"></a>
              <div class="contact-details">
                <h2>The American Club</h2>
                <p class="address">10 Claymore Hill<br>Singapore, 229573</p>
                <div class="contact-info">
                  <p class="contact-phone">+65 6737 3411</p>
                  <p class="contact-email">info@amclub.org.sg</p>
                </div>
              </div>
              <div class="social-links">
                <a href="#" aria-label="Facebook"><i class="fab fa-facebook"></i></a>
                <a href="#" aria-label="Instagram"><i class="fab fa-instagram"></i></a>
                <a href="#" aria-label="LinkedIn"><i class="fab fa-linkedin"></i></a>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <!-- Hero Banner Section -->
    <section class="banner" id="hero">
      <div class="banner-slider">
        <div class="banner-slide active">
          <img src="/tac/images/membership/banner/membership-banner-01.png" alt="Banner Image 1">
        </div>
        <div class="banner-slide">
          <img src="/tac/images/membership/banner/membership-banner-02.png" alt="Banner Image 2">
        </div>
      </div>
      <div class="banner-content">
        <div class="banner-overlay"></div>
        <div class="banner-text">
          <p>Join the American Club</p>
          <h1>Explore Your Path to Membership</h1>
          <a href="#" class="cta-button secondary">Join Us</a>
        </div>
      </div>
      <button class="scroll-down-btn" aria-label="Scroll to next section">
        <i class="fa-solid fa-chevron-down"></i>
      </button>
    </section>

    <!-- Text Section 1 -->
    <section class="text-section text-section-1">
      <div class="container">
        <div class="content-wrapper">
          <h1 class="section-title">A Membership That Matches Your Life</h1>
          <p class="section-body">Your reasons for joining are uniquely yours. That’s why we offer thoughtfully curated membership categories so you can choose how you experience The American Club, and who you bring with you.</p>
        </div>
      </div>
    </section>

    <!-- Highlights Section -->
    <section class="highlights-section" id="highlights">
      <div class="container">
        <div class="highlights-wrapper">
          <div class="highlights-column highlights-column-1">
            <div class="highlights-card club">
                <div class="highlights-content">
                  <h3 class="section-title">Individual</h3>
                  <p class="section-body">Wherever your travels take you, your membership travels with you. With access to prestigious Reciprocal Clubs around the world, you’ll always be welcomed like family, no matter the city or the continent.</p>
                  <a href="#" class="cta-button secondary">Learn More</a>
                </div>
            </div>  
            <div class="highlights-card supplementary">
                <div class="highlights-content">
                  <h3 class="section-title">Supplementary Membership Categories</h3>
                  <p class="section-body">We understand that home includes more than your immediate household. Apply for a Supplementary Membership card for your parents, children, or long-term guests, and share The Club with those who matter most.</p>
                  <a href="#" class="cta-button secondary">Learn More</a>
                </div>
              </div>
          </div>
          <div class="highlights-column highlights-column-2">
            <div class="highlights-card niche">
              <div class="highlights-content">
                <h3 class="section-title">Niche Group Membership</h3>
                <p class="section-body">The Niche Group Membership celebrates those who’ve made The American Club a lasting part of their lives. With exclusive tiers based on tenure or spending, it’s our way of saying thank you.</p>
                <a href="#" class="cta-button secondary">Learn More</a>
              </div>
            </div>
            <div class="highlights-card refer">
              <div class="highlights-content">
                <h3 class="section-title">Refer a Friend</h3>
                <p class="section-body">Share The American Club lifestyle with those you value most. Introduce a friend and be rewarded* with Club dining vouchers, because good taste should always be shared.</p>
                <a href="#" class="cta-button secondary">Learn More</a>
              </div>
          </div>
        </div>
      </div>
    </section>

    <!-- Banner Section -->
    <section class="banner-normal" id="tour">
        <div class="banner-slider">
            <div class="banner-slide active">
                <img src="/tac/images/membership/virtual-club-tour-bg.webp" alt="Tour">
            </div>
        </div>
        <div class="banner-content">
            <div class="banner-text">
                <h1>Virtual Club Tour</h1>
                <p class="section-body">Take a digital stroll through our vibrant dining, fitness, and community spaces.</p>
                <a href="#" class="cta-button secondary">Learn More</a>
            </div>
        </div>
    </section>

    <!-- Banner Section -->
    <section class="banner-normal" id="joining-fees">
        <div class="banner-slider">
            <div class="banner-slide active">
                <img src="/tac/images/membership/joining-fees-bg.png" alt="Joining Fees">
            </div>
        </div>
        <div class="banner-content">
            <div class="banner-text">
                <h1>Joining Fees</h1>
                <p class="section-body">The American Club offers multiple pathways to membership. Explore our joining fees and see how you can become part of something truly special.</p>
                <div class="banner-buttons">
                    <a href="#" class="cta-button primary">Start Your Application</a>
                    <a href="#" class="cta-button primary">View More</a>
                </div>
            </div>
        </div>
    </section>



    <!-- Footer -->
    <footer class="footer">
      <div class="container">
        <div class="footer-content-wrapper footer-row-1">
          <div class="footer-content footer-left">
            <div class="footer-section">
              <h4>ABOUT US</h4>
              <ul>
                <li><a href="#">Club Governance</a></li>
                <li><a href="#">Club Constitution</a></li>
              </ul>
            </div>
            <div class="footer-section">
              <h4>SERVICES</h4>
              <ul>
                <li><a href="#">Wine & Dine</a></li>
                <li><a href="#">Fitness & Leisure</a></li>
                <li><a href="#">Youth & Family</a></li>
                <li><a href="#">Club Services</a></li>
                <li><a href="#">Member Services</a></li>
                <li><a href="#">Business</a></li>
              </ul>
            </div>
            <div class="footer-section">
              <h4>NEWS & EVENTS</h4>
              <ul>
                <li><a href="#">News Updates</a></li>
                <li><a href="#">Events</a></li>
                <li><a href="#">Calendar</a></li>
              </ul>
            </div>
            <div class="footer-section">
              <h4>MEDIA</h4>
              <ul>
                <li><a href="#">Gallery</a></li>
                <li><a href="#">Publications</a></li>
              </ul>
            </div>
            <div class="footer-section">
              <h4>CONTACT US</h4>
              <ul>
                <li><a href="#">Career</a></li>
                <li><a href="#">Partner with us</a></li>
                <li><a href="#">Membership</a></li>
              </ul>
            </div>
            <div class="footer-section">
              <h4>SHOP</h4>
            </div>
          </div>
          <div class="footer-content footer-right">
            <img src="/tac/images/tac-logo.webp" alt="The American Club Logo">
            <p>10 Claymore Hill Singapore, 229573</p>
            <p>+65 6737 3411</p>
            <p>info@amclub.org.sg</p>
          </div>
        </div>
        <div class="footer-content-wrapper footer-row-2">
          <p>Subscribe to our newsletter for the latest updates</p>
          <a href="#" class="cta-button secondary">Subscribe</a>
        </div>
        <div class="footer-content-wrapper footer-row-3">
          <div class="social-links">
            <a href="#" aria-label="Facebook"><i class="fab fa-facebook"></i></a>
            <a href="#" aria-label="Instagram"><i class="fab fa-instagram"></i></a>
            <a href="#" aria-label="LinkedIn"><i class="fab fa-linkedin"></i></a>
            <a href="#" aria-label="WhatsApp"><i class="fab fa-whatsapp"></i></a>
          </div>
        </div>
        <div class="footer-content-wrapper footer-row-4">
          <p>&copy; 2025 The American Club Singapore. All rights reserved.</p>
          <div class="footer-row-4-right">
            <a href="#">Privacy Policy</a>
            <a href="#">Terms of Use</a>
            <a href="#">Cookies Policy</a>
            <a href="#">Legal Notice</a>
          </div>
        </div>
      </div>
    </footer>

    <script type="module" src="/tac/main.js?v=<?php echo time(); ?>"></script>
    <!-- Glide.js -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@glidejs/glide@3.6.0/dist/css/glide.core.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@glidejs/glide@3.6.0/dist/css/glide.theme.min.css">
    <script src="https://cdn.jsdelivr.net/npm/@glidejs/glide@3.6.0/dist/glide.min.js"></script>
  </body>
</html>