const events = [
    {
    // July
    date: '2025-07-07',
    title: 'Mahjong Social @ The American Club',
    time: '1:00 p.m. – 4:00 p.m.',
    location: 'The Galbraith Ballroom',
    description: 'Commonly played by four persons at a square table, Mahjong is a classic game of strategy, skill and luck. Both new and experienced players will have an enjoyable time while forging new friendships.',
    category: 'Social',
    image: '/tac/images/event-calendar/mahjong-social.png',
    link: '/tac/event.php'
    },
    {
    date: '2025-07-09',
    title: 'Golf Friendly with Tanglin Club',
    time: '12:00 p.m. onwards',
    location: 'Keppel Club',
    description: 'The American Club Members are invited to take part in Tanglin Club’s upcoming Golf Friendly at Keppel Club. Enjoy a great day on the green and connect with fellow golf enthusiasts in this friendly interclub game.',
    category: 'Sports',
    image: '/tac/images/event-calendar/golf-friendly.png',
    link: '/tac/event.php'
    },
    {
    date: '2025-07-23',
    title: 'Art Launch: Vibrant Rhapsody',
    time: '6:00 p.m. – 7:30 p.m.',
    location: 'Thinkspace',
    description: 'Founded in 2017, Olive Gallery is dedicated to celebrating contemporary artists from across Asia.',
    category: 'Art',
    image: '/tac/images/event-calendar/vibrant-rhapsody.png',
    link: '/tac/event.php'
    },
    {
    date: '2025-07-26',
    title: 'Nostalgic Flavors of Singapore',
    time: '',
    location: 'Tradewinds',
    description: 'Delhi Lahori, an Indian-Pakistani eatery at Tekka Centre, proudly features on the 2024 Michelin Bib Gourmand list. They offer a rich variety of authentic dishes, including charcoal-baked Naans and fragrant curries.',
    category: 'Food',
    image: '/tac/images/event-calendar/nostalgic-flavors.png',
    link: '/tac/event.php'
    },
    
    // June
    {
    date: '2025-06-20',
    title: 'June Community Cleanup',
    time: '9:00 a.m. – 12:00 p.m.',
    location: 'Central Park',
    description: 'Join us in keeping our community clean and green.',
    category: 'Social',
    image: '/tac/images/event-calendar/mahjong-social.png',
    link: '/tac/event.php'
    }
];

function renderEvents() {
  const selectedMonth = document.getElementById('month-filter').value;
  const selectedYear = document.getElementById('year-filter').value;
  const selectedCategories = $('#category-filter').val(); // array of selected values
  const list = document.getElementById('event-list');
  const label = document.getElementById('current-month-label');

  // Update the display label
  label.textContent = `${selectedMonth} ${selectedYear}`;

  const filtered = events
    .filter(event => {
      const date = new Date(event.date);
      const month = date.toLocaleString('default', { month: 'long' });
      const year = date.getFullYear().toString();

      // ✅ Correct category check
      const categoryMatch =
        !selectedCategories || selectedCategories.length === 0 || selectedCategories.includes(event.category);

      return (
        month === selectedMonth &&
        year === selectedYear &&
        categoryMatch
      );
    })
    .sort((a, b) => new Date(a.date) - new Date(b.date));

  // Clear existing list
  list.innerHTML = '';
  let lastDateLabel = '';

  filtered.forEach(event => {
    const date = new Date(event.date);
    const dateDay = date.toLocaleDateString('default', { weekday: 'long' });
    const dateLabel = `${date.getDate()} ${date.toLocaleString('default', { month: 'long' })}`;

    // Add date header only if not already added
    if (dateLabel !== lastDateLabel) {
      const wrapper = document.createElement('div');
      wrapper.className = 'event-date-wrapper';

      const dot = document.createElement('span');
      dot.className = 'event-dot';

      const label = document.createElement('div');
      label.className = 'event-date-label';
      label.setAttribute('data-aos', 'fade-left');
      label.setAttribute('data-aos-duration', '1000');
      label.innerHTML = `${dateLabel} <span class="event-day-label">${dateDay}</span>`;

      wrapper.appendChild(dot);
      wrapper.appendChild(label);
      list.appendChild(wrapper);

      lastDateLabel = dateLabel;
    }

    // Create event card
    const card = document.createElement('a');
    card.className = 'event-card';
    card.href = event.link || '#';

    card.setAttribute('data-aos', 'fade-left');
    card.setAttribute('data-aos-duration', '1000');
    card.setAttribute('data-aos-delay', '200');

    card.innerHTML = `
      <div class="event-details">
        <div class="event-title">${event.title}</div>
        <div class="event-time">${event.time}</div>
        <div class="event-location">
          <img src="/tac/images/event-calendar/location-pin-icon.png"> ${event.location}
        </div>
        <div class="event-description">${event.description}</div>
      </div>
      <div class="event-image">
        <img src="${event.image}" alt="${event.title}">
      </div>
    `;

    list.appendChild(card);
  });

  // Show message if none match
  if (filtered.length === 0) {
    list.innerHTML = '<p style="margin-left: 1rem;">No events found.</p>';
  }
}



document.getElementById('month-filter').addEventListener('change', renderEvents);
document.getElementById('category-filter').addEventListener('change', renderEvents);
document.addEventListener('DOMContentLoaded', () => {
  const currentDate = new Date();
  const currentMonthName = currentDate.toLocaleString('default', { month: 'long' });
  const currentYear = currentDate.getFullYear().toString();

  document.getElementById('month-filter').value = currentMonthName;
  document.getElementById('year-filter').value = currentYear;

  $('#category-filter').select2({
    placeholder: 'Category'
  });

  $('#category-filter').val([]).trigger('change'); // Clear by default

  document.getElementById('month-filter').addEventListener('change', renderEvents);
  document.getElementById('year-filter').addEventListener('change', renderEvents);
  $('#category-filter').on('change', renderEvents); // jQuery listener

  renderEvents();
});






