<!doctype html>
<html lang="en">
  <!-- Head -->
  <?php include 'head.php'; ?>
  
  <body class="home event-calendar">
    <!-- Header -->
    <?php include 'header.php'; ?>

    <!-- Hero Banner Section -->
    <section class="banner" id="hero">
      <div class="banner-slider">
        <div class="banner-slide active">
          <img src="/tac/images/event-calendar/banner/event-calendar-hero.webp" alt="Banner Image 1">
        </div>
      </div>
      <div class="banner-content">
        <div class="banner-text">
          <p>Join the American Club</p>
          <h1>Events, Gatherings, &<br>Good Times</h1>
          <a href="/tac/" class="cta-button secondary">Back to Home</a>
        </div>
      </div>
      <button class="scroll-down-btn" aria-label="Scroll to next section">
        <i class="fa-solid fa-chevron-down"></i>
      </button>
    </section>

    <!-- Video Modal -->
    <div class="video-modal" id="videoModal">
      <div class="video-modal-content">
        <button class="video-modal-close" aria-label="Close video modal">
          <i class="fas fa-times"></i>
        </button>
        <video controls>
          <source src="/tac/videos/home-video.mp4" type="video/mp4">
          <source src="/tac/videos/home-video.webm" type="video/webm">
          Your browser does not support the video tag.
        </video>
      </div>
    </div>

    <!-- Text Section 1 -->
    <section class="text-section text-section-1">
      <div class="container">
        <div class="content-wrapper">
          <h1 class="section-title" data-aos="fade-right" data-aos-duration="1000">Mark Your Calendar,<br>Here's What's On</h1>
          <p class="section-body"  data-aos="fade-up" data-aos-duration="1000" data-aos-delay="100">Our events are designed to bring people together in genuine connection and warm support. Check out what’s next — we can’t wait to welcome you.</p>
        </div>
      </div>
    </section>

    <section class="event-calendar-section">
        <div class="event-calendar-header">
        <h2 id="current-month-label" data-aos="fade-up" data-aos-duration="1000">July</h2>
        <div class="calendar-filter" data-aos="fade-up" data-aos-duration="1000">
            <div class="calendar-filter-row">
              <select id="year-filter">
                <option value="2024">2024</option>
                <option value="2025">2025</option>
                <option value="2026">2026</option>
              </select>
              <select id="month-filter" >
              <option value="January">January</option>
              <option value="February">February</option>
              <option value="March">March</option>
              <option value="April">April</option>
              <option value="May">May</option>
              <option value="June">June</option>
              <option value="July">July</option>
              <option value="August">August</option>
              <option value="September">September</option>
              <option value="October">October</option>
              <option value="November">November</option>
              <option value="December">December</option>
              </select>
            </div>
            <div>
              <select id="category-filter" multiple>
                <option value="Social">Social</option>
                <option value="Sports">Sports</option>
                <option value="Art">Art</option>
                <option value="Food">Food</option>
              </select>
            </div>


        </div>
        </div>
        <div id="event-list" class="event-list">
        <!-- Events inserted here via JS -->
        </div>
    </section>
    
    <!-- Banner Section -->
    <section class="banner-normal" id="joining-fees">
        <div class="banner-slider">
            <div class="banner-slide active">
                <img src="/tac/images/membership/joining-fees-bg-01.png" alt="Joining Fees">
            </div>
        </div>
        <div class="banner-content">
            <div class="banner-text">
                <h1>Youth Class Schedule</h1>
                <p class="section-body">Fitness & Leisure class schedules can be found on the respective sport’s page under the ‘Fitness & Leisure’ tab in the menu bar above.<br>Click here to view the Youth class schedule.</p>
                <div class="banner-buttons">
                    <a href="#" class="cta-button primary">View More</a>
                </div>
            </div>
        </div>
    </section>

    <!-- Events Section -->
    <section class="events-section" id="events">
      <div class="container">
        <div class="events-wrapper">
          <div class="events-content">
            <h2 class="section-title" data-aos="fade-right" data-aos-duration="1000">Feature Events</h2>
            <p class="section-body" data-aos="fade-right" data-aos-duration="1000" data-aos-delay="100">Exclusive member events, themed evenings, and family days. If it's happening at The American Club, you won't want to miss it.</p>
            <div class="card-nav">
              <button class="nav-btn prev" aria-label="Previous event">
                <i class="fas fa-chevron-left"></i>
              </button>
              <button class="nav-btn next" aria-label="Next event">
                <i class="fas fa-chevron-right"></i>
              </button>
            </div>
          </div>
          <div class="stack">
            <div class="card">
              <div class="events-image">
                <img src="/tac/images/home/events/tradewinds.png">
              </div>
              <div class="events-info">
                <img src="/tac/images/home/brands/tradewinds.png">
                <h3>Asian Delight Brunch</h3>
                <span class="event-time">July - September, 2025</span>
                <p>This Father's Day, raise a glass to Dad with bold cocktails and hearty dishes crafted for the occasion.</p>
                <a href="/tac/tradewinds.php" class="cta-button primary">Learn More</a>
              </div>
            </div>
            <div class="card">
              <div class="events-image">
                <img src="/tac/images/home/events/the2ndfloor.png">
              </div>
              <div class="events-info">
                <img src="/tac/images/home/brands/the-2nd-floor-logo.png">
                <h3>Indulge in Romance</h3>
                <span class="event-time">July - September, 2025</span>
                <p>Celebrate love with a special dinner at The 2nd Floor. With artful plating and premium wine pairings, our Valentine's Dinner Special is crafted to create meaningful, lasting memories.</p>
                <a href="/tac/tradewinds.php" class="cta-button primary">Learn More</a>
              </div>
            </div>
            <div class="card">
              <div class="events-image">
                <img src="/tac/images/home/events/grillhouse.png">
              </div>
              <div class="events-info">
                <img src="/tac/images/home/brands/grillhouse-logo.png">
                <h3>Always Fresh Off the Grill</h3>
                <span class="event-time">July - September, 2025</span>
                <p>Enjoy the sizzling flavors of Grillhouse this season. Think juicy burgers, crispy sides, and chilled beers, all served fresh off the grill. A casual, satisfying dining spot for laid-back meals with friends and family.</p>
                <a href="/tac/tradewinds.php" class="cta-button primary">Learn More</a>
              </div>
            </div>
            <div class="card">
              <div class="events-image">
                <img src="/tac/images/home/events/thegourmetpantry.png">
              </div>
              <div class="events-info">
                <img src="/tac/images/home/brands/the-gourmet-pantry-logo.png">
                <h3>Cheese Selection</h3>
                <span class="event-time">July - September, 2025</span>
                <p>Discover our curated range of gourmet cheeses at The Gourmet Pantry. From soft and creamy to sharp and aged, there's something to suit every palate. Ideal for entertaining or indulging in a quiet moment of luxury.</p>
                <a href="/tac/tradewinds.php" class="cta-button primary">Learn More</a>
              </div>
            </div>
            <div class="card">  
              <div class="events-image">
                <img src="/tac/images/home/events/central.png">
              </div>
              <div class="events-info">
                <img src="/tac/images/home/brands/central-logo.png">
                <h3>Cream Burlee Latte</h3>
                <span class="event-time">July - September, 2025</span>
                <p>Introducing the new Cream Brûlée Latte at Central. This indulgent drink blends rich espresso, silky cream, and a torched caramelized topping. Perfect for a midday treat or your next coffee date.</p>
                <a href="/tac/tradewinds.php" class="cta-button primary">Learn More</a>
              </div>
            </div>
            <div class="card">  
              <div class="events-image">
                <img src="/tac/images/home/events/senspa.png">
              </div>
              <div class="events-info">
                <img src="/tac/images/home/brands/senspa-logo.png">
                <h3>Glow Up Your Skin</h3>
                <span class="event-time">July - September, 2025</span>
                <p>Treat your skin to a rejuvenating facial at sên Spa. Our seasonal Glow Up treatment is designed to restore radiance and hydration, leaving you glowing skin and ready to take on the day.</p>
                <a href="/tac/tradewinds.php" class="cta-button primary">Learn More</a>
              </div>
            </div>
            <div class="card">  
              <div class="events-image">
                <img src="/tac/images/home/events/thequad.png">
              </div>
              <div class="events-info">
                <img src="/tac/images/home/brands/thequad-logo.png">
                <h3>Endless Fun for Everyone</h3>
                <span class="event-time">July - September, 2025</span>
                <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam,</p>
                <a href="/tac/tradewinds.php" class="cta-button primary">Learn More</a>
              </div>
            </div>
          </div>
          <div class="mobile-events-carousel">
            <div class="carousel-track">
              <div class="carousel-slide">
                <div class="events-image">
                  <img src="/tac/images/home/events/tradewinds.png">
                </div>
                <div class="events-info">
                  <img src="/tac/images/home/brands/tradewinds.png">
                  <h3>Asian Delight Brunch</h3>
                  <span class="event-time">July - September, 2025</span>
                  <p>This Father's Day, raise a glass to Dad with bold cocktails and hearty dishes crafted for the occasion.</p>
                  <a href="/tac/tradewinds.php" class="cta-button primary">Learn More</a>
                </div>
              </div>
              <div class="carousel-slide">
                <div class="events-image">
                  <img src="/tac/images/home/events/the2ndfloor.png">
                </div>
                <div class="events-info">
                  <img src="/tac/images/home/brands/the-2nd-floor-logo.png">
                  <h3>Indulge in Romance</h3>
                  <span class="event-time">July - September, 2025</span>
                  <p>Large, artfully composed images of food and drinks, framed with thin gold borders or gold abstract lines, enhance the ambiance without overpowering it.</p>
                  <a href="/tac/tradewinds.php" class="cta-button primary">Learn More</a>
                </div>
              </div>
              <div class="carousel-slide">
                <div class="events-image">
                  <img src="/tac/images/home/events/grillhouse.png">
                </div>
                <div class="events-info">
                  <img src="/tac/images/home/brands/grillhouse-logo.png">
                  <h3>Always Fresh Off the Grill</h3>
                  <span class="event-time">July - September, 2025</span>
                  <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam,</p>
                  <a href="/tac/tradewinds.php" class="cta-button primary">Learn More</a>
                </div>
              </div>
              <div class="carousel-slide">
                <div class="events-image">
                  <img src="/tac/images/home/events/thegourmetpantry.png">
                </div>
                <div class="events-info">
                  <img src="/tac/images/home/brands/the-gourmet-pantry-logo.png">
                  <h3>Cheese Selection</h3>
                  <span class="event-time">July - September, 2025</span>
                  <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam,</p>
                  <a href="/tac/tradewinds.php" class="cta-button primary">Learn More</a>
                </div>
              </div>
              <div class="carousel-slide">
                <div class="events-image">
                  <img src="/tac/images/home/events/central.png">
                </div>
                <div class="events-info">
                  <img src="/tac/images/home/brands/central-logo.png">
                  <h3>Cream Burlee Latte</h3>
                  <span class="event-time">July - September, 2025</span>
                  <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam,</p>
                  <a href="/tac/tradewinds.php" class="cta-button primary">Learn More</a>
                </div>
              </div>
              <div class="carousel-slide">
                <div class="events-image">
                  <img src="/tac/images/home/events/senspa.png">
                </div>
                <div class="events-info">
                  <img src="/tac/images/home/brands/senspa-logo.png">
                  <h3>Glow Up Your Skin</h3>
                  <span class="event-time">July - September, 2025</span>
                  <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam,</p>
                  <a href="/tac/tradewinds.php" class="cta-button primary">Learn More</a>
                </div>
              </div>
              <div class="carousel-slide">
                <div class="events-image">
                  <img src="/tac/images/home/events/thequad.png">
                </div>
                <div class="events-info">
                  <img src="/tac/images/home/brands/thequad-logo.png">
                  <h3>Asian Delight Brunch</h3>
                  <span class="event-time">July - September, 2025</span>
                  <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam,</p>
                  <a href="/tac/tradewinds.php" class="cta-button primary">Learn More</a>
                </div>
              </div>
            </div>
            <div class="carousel-nav">
              <button class="nav-btn prev" aria-label="Previous event">
                <i class="fas fa-chevron-left"></i>
              </button>
              <button class="nav-btn next" aria-label="Next event">
                <i class="fas fa-chevron-right"></i>
              </button>
            </div>
            <div class="carousel-dots">
              <span class="carousel-dot active"></span>
              <span class="carousel-dot"></span>
              <span class="carousel-dot"></span>
              <span class="carousel-dot"></span>
              <span class="carousel-dot"></span>
              <span class="carousel-dot"></span>
              <span class="carousel-dot"></span>
            </div>
          </div>
        </div>
      </div>
    </section>

    <!-- Footer -->
    <?php include 'footer.php'; ?>

    <script src="event-calendar.js?v=<?php echo time(); ?>"></script>
  </body>
</html>