<!doctype html>
<html lang="en">
  <!-- Head -->
  <?php include 'head.php'; ?>
  
  <body class="event">
    <!-- Header -->
    <?php include 'header.php'; ?>

    <!-- Hero Banner Section -->
    <section class="banner" id="hero">
      <div class="banner-slider">
        <div class="banner-slide active">
          <img src="/tac/images/event/banner/event-hero.webp" alt="Banner Image 1">
        </div>
      </div>
      <div class="banner-content">
        <div class="banner-text">
          <p>Art Launch</p>
          <h1>Vibrant Rhapsody<br>by Olive Gallery</h1>
          <a href="/tac/event-calendar.php" class="cta-button secondary">Back to Events Calendar</a>
        </div>
      </div>
      <button class="scroll-down-btn" aria-label="Scroll to next section">
        <i class="fa-solid fa-chevron-down"></i>
      </button>
    </section>

    <!-- Text Section 1 -->
    <section class="text-section text-section-1">
        <div class="container">
            <div class="brand-logo" data-aos="fade-up" data-aos-duration="1000">
                <img src="/tac/images/event/vibrant-rhapsody.png" alt="Vibrant Rhapsody Logo">
            </div>
            <div class="content-wrapper">
                <p class="section-body" data-aos="fade-up" data-aos-duration="1000" data-aos-delay="100">Founded in 2017, Olive Gallery is dedicated to celebrating contemporary artists from across Asia. Our collective includes renowned talents such as Sanjay Chakraborty, whose spatula work creates striking layers of color; Mahesh Karambele, celebrated for his evocative abstract cityscapes; and Smrita Swarup, founder of the gallery, whose floral abstracts explore vibrant, layered forms inspired by environmental appreciation and climate consciousness.</p>

                <p class="section-body" data-aos="fade-up" data-aos-duration="1000" data-aos-delay="200">Guided by a shared vision, we are committed to presenting exceptional contemporary art. We’re also proud to welcome acclaimed Asian artists David Tay, Win Chung, and others to our growing collective—whose works will be featured in our upcoming exhibition at The American Club.</p>

                <a href="#" class="cta-button primary" data-aos="fade-up" data-aos-duration="1000" data-aos-delay="300">Register Here</a>
            </div>
        </div>

        <div class="container">
            <div class="details-wrapper">
                <div class="text-column">
                    <div class="decorative-line"></div>
                    <div class="operating-hours-wrapper">
                        <div class="operating-hours" data-aos="fade-right" data-aos-duration="1000">
                            <h4>Operating Hours</h4>
                            <p>
                                6:00 P.M. – 7:30 P.M.<br><br>
                                Complimentary Event for Members
                            </p>
                        </div>

                        <div class="operating-hours" data-aos="fade-right" data-aos-duration="1000" data-aos-delay="200">
                            <h4>Location</h4>
                            <p>
                                Thinkspace
                            </p>
                        </div>

                        <div class="operating-hours" data-aos="fade-right" data-aos-duration="1000" data-aos-delay="200">
                            <h4>Art Exhibition</h4>
                            <h4>
                                July 1 - September, 2025
                            </h4>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </section>

    <section class="event-featured">
        <div class="event-featured-item featured-item-1">
            <img src="/tac/images/event/featured-item-01.png">
        </div>

        <div class="event-featured-item featured-item-2">
            <img src="/tac/images/event/featured-item-02.png">
        </div>

        <div class="event-featured-item featured-item-3">
            <img src="/tac/images/event/featured-item-03.png">
        </div>
    </section>
    <!-- Footer -->
    <?php include 'footer.php'; ?>


  </body>
</html>