<!doctype html>
<html lang="en">
  <!-- Head -->
  <?php include 'head.php'; ?>
  
  <body class="home">
    <!-- Header -->
    <?php include 'header.php'; ?>

    <!-- Hero Banner Section -->
    <section class="banner" id="hero">
      <div class="overlay-animation">
        <svg class="overlay-mask" viewBox="0 0 1440 150" preserveAspectRatio="none">
          <defs>
            <linearGradient id="overlayGradient" x1="0" y1="1" x2="0" y2="0">
              <stop offset="0%" stop-color="white" stop-opacity="1" />
              <stop offset="20%" stop-color="white" stop-opacity="1" />
              <stop offset="40%" stop-color="white" stop-opacity="0.8" />
              <stop offset="60%" stop-color="white" stop-opacity="0.6" />
              <stop offset="80%" stop-color="white" stop-opacity="0.3" />
              <stop offset="90%" stop-color="white" stop-opacity="0.1" />
              <stop offset="100%" stop-color="white" stop-opacity="0" />
            </linearGradient>
          </defs>
          <path d="M0,96 C360,192 1080,0 1440,96 L1440,0 L0,0 Z" fill="url(#overlayGradient)" />
        </svg>
      </div>
      <div class="banner-slider">
        <!-- Video Slide -->
        <div class="banner-slide video-slide active">
          <video autoplay muted playsinline>
            <source src="/tac/videos/home-video.mp4" type="video/mp4">
            <source src="/tac/videos/home-video.webm" type="video/webm">
            Your browser does not support the video tag.
          </video>
          <div class="video-overlay">
            <button class="video-play-btn" aria-label="Play video in fullscreen">
              <i class="fas fa-play"></i>
            </button>
          </div>
        </div>
        <div class="banner-slide">
          <img src="/tac/images/home/banner/home-hero-01.webp" alt="Banner Image 1">
        </div>
        <div class="banner-slide">
          <img src="/tac/images/home/banner/home-hero-02.webp" alt="Banner Image 2">
        </div>
        <div class="banner-slide">
          <img src="/tac/images/home/banner/home-hero-03.webp" alt="Banner Image 3">
        </div>
        <div class="banner-slide">
          <img src="/tac/images/home/banner/home-hero-04.webp" alt="Banner Image 4">
        </div>
        <div class="banner-slide">
          <img src="/tac/images/home/banner/home-hero-05.webp" alt="Banner Image 5">
        </div>
        <div class="banner-slide">
          <img src="/tac/images/home/banner/home-hero-06.webp" alt="Banner Image 6">
        </div>
      </div>
      
      <!-- New Video Banner Section -->
      <!-- <div class="video-banner">
        <video autoplay muted loop playsinline>
          <source src="/tac/videos/home-video.mp4" type="video/mp4">
          <source src="/tac/videos/home-video.webm" type="video/webm">
          Your browser does not support the video tag.
        </video>
        <div class="video-overlay">
          <button class="video-play-btn" aria-label="Play video in fullscreen">
            <i class="fas fa-play"></i>
          </button>
        </div>
      </div> -->
      
      <div class="banner-content">
        <div class="banner-text">
          <p>Welcome to The American Club. Exclusively Yours</p>
          <h1>More Than a Club.<br>A Place to Call Home.</h1>
          <a href="/tac/membership.php" class="cta-button secondary">Get to Know Us</a>
        </div>
      </div>
      <button class="scroll-down-btn" aria-label="Scroll to next section">
        <i class="fa-solid fa-chevron-down"></i>
      </button>
    </section>

    <!-- Video Modal -->
    <div class="video-modal" id="videoModal">
      <div class="video-modal-content">
        <button class="video-modal-close" aria-label="Close video modal">
          <i class="fas fa-times"></i>
        </button>
        <video controls>
          <source src="/tac/videos/home-video.mp4" type="video/mp4">
          <source src="/tac/videos/home-video.webm" type="video/webm">
          Your browser does not support the video tag.
        </video>
      </div>
    </div>

    <!-- Text Section 1 -->
    <section class="text-section text-section-1">
      <div class="container">
          <h4  data-aos="fade-down" data-aos-duration="1000">WELCOME</h4>
        <div class="content-wrapper">
          <h1 class="section-title" data-aos="fade-right" data-aos-duration="1000">Discover Your Private<br>Escape in the City</h1>
          <p class="section-body"  data-aos="fade-up" data-aos-duration="1000" data-aos-delay="100">The American Club offers a steady sense of community and purpose. With world-class facilities and heartfelt service, we bring a warm, welcoming spirit to life in a relaxed retreat where families and individuals can connect, unwind and feel at home.</p>
          <a href="/tac/membership.php" class="cta-button primary" data-aos="fade-up" data-aos-duration="1000" data-aos-delay="300">BECOME A MEMBER</a>
        </div>
      </div>
    </section>

    <!-- Services Section -->
    <section class="services-section" id="services">
      <div class="container">
        <h2 class="section-title" data-aos="fade-right" data-aos-duration="1000">American Club Services</h2>
        <div class="splide services-splide">
          <div class="splide__track">
            <ul class="splide__list">
              <li class="splide__slide">
                <div class="service-card">
                  <div class="service-image">
                    <img src="/tac/images/home/services/wine-and-dine.webp" alt="Wine and Dining">
                  </div>
                  <div class="service-content">
                    <h3>Wine & Dine</h3>
                    <p>Go on a culinary journey that blends global flavours across a variety of upscale dining values.</p>
                    <a href="/tac/wine-and-dine.php" class="cta-button primary">Learn More</a>
                  </div>
                </div>
              </li>
              <li class="splide__slide">
                <div class="service-card">
                  <div class="service-image">
                    <img src="/tac/images/home/services/fitness-and-leisure.webp" alt="Fitness & Leisure">
                  </div>
                  <div class="service-content">
                    <h3>Fitness & Leisure</h3>
                    <p>State-of-the-art facilities, group classes, personal training, and tranquil retreats all designed to keep you active, energised, and well.</p>
                    <a href="/tac/wine-and-dine.php" class="cta-button primary">Learn More</a>
                  </div>
                </div>
              </li>
              <li class="splide__slide">
                <div class="service-card">
                  <div class="service-image">
                    <img src="/tac/images/home/services/youth-and-family.webp" alt="Youth & Family">
                  </div>
                  <div class="service-content">
                    <h3>Youth & Family</h3>
                    <p>Spaces and programs for every age with family-first activities, camps, and educational fun all year round, so everyone feels at home.</p>
                    <a href="/tac/wine-and-dine.php" class="cta-button primary">Learn More</a>
                  </div>
                </div>
              </li>
              <li class="splide__slide">
                <div class="service-card">
                  <div class="service-image">
                    <img src="/tac/images/home/services/club-services-01.webp" alt="Club Services">
                  </div>
                  <div class="service-content">
                    <h3>Club Services</h3>
                    <p>Everything you need, without ever leaving. Whether you're working, relaxing, or simply living, The Club is designed around you.</p>
                    <a href="/tac/wine-and-dine.php" class="cta-button primary">Learn More</a>
                  </div>
                </div>
              </li>
              <li class="splide__slide">
                <div class="service-card">
                  <div class="service-image">
                    <img src="/tac/images/home/services/member-services.webp" alt="Member Services">
                  </div>
                  <div class="service-content">
                    <h3>Member Services</h3>
                    <p>From an attentive concierge service to our expert membership team, We're here to welcome you seamlessly into The American Club.</p>
                    <a href="/tac/wine-and-dine.php" class="cta-button primary">Learn More</a>
                  </div>
                </div>
              </li>
            </ul>
          </div>
        </div>
      </div>
    </section>

    <!-- Events Section -->
    <section class="events-section" id="events">
      <div class="container">
        <div class="events-wrapper">
          <div class="events-content">
            <h2 class="section-title" data-aos="fade-right" data-aos-duration="1000">Stay In The Know</h2>
            <p class="section-body" data-aos="fade-right" data-aos-duration="1000" data-aos-delay="100">Exclusive member events, themed evenings, and family days. If it's happening at The American Club, you won't want to miss it.</p>
            <a href="/tac/event-calendar.php" class="cta-button secondary"  data-aos="fade-right" data-aos-duration="1000" data-aos-delay="200">View the full calendar</a>
            <div class="card-nav">
              <button class="nav-btn prev" aria-label="Previous event">
                <i class="fas fa-chevron-left"></i>
              </button>
              <button class="nav-btn next" aria-label="Next event">
                <i class="fas fa-chevron-right"></i>
              </button>
            </div>
          </div>
          <div class="stack">
            <div class="card">
              <div class="events-image">
                <img src="/tac/images/home/events/tradewinds.png">
              </div>
              <div class="events-info">
                <img src="/tac/images/home/brands/tradewinds.png">
                <h3>Asian Delight Brunch</h3>
                <span class="event-time">July - September, 2025</span>
                <p>This Father's Day, raise a glass to Dad with bold cocktails and hearty dishes crafted for the occasion.</p>
                <a href="/tac/tradewinds.php" class="cta-button primary">Learn More</a>
              </div>
            </div>
            <div class="card">
              <div class="events-image">
                <img src="/tac/images/home/events/the2ndfloor.png">
              </div>
              <div class="events-info">
                <img src="/tac/images/home/brands/the-2nd-floor-logo.png">
                <h3>Indulge in Romance</h3>
                <span class="event-time">July - September, 2025</span>
                <p>Celebrate love with a special dinner at The 2nd Floor. With artful plating and premium wine pairings, our Valentine's Dinner Special is crafted to create meaningful, lasting memories.</p>
                <a href="/tac/tradewinds.php" class="cta-button primary">Learn More</a>
              </div>
            </div>
            <div class="card">
              <div class="events-image">
                <img src="/tac/images/home/events/grillhouse.png">
              </div>
              <div class="events-info">
                <img src="/tac/images/home/brands/grillhouse-logo.png">
                <h3>Always Fresh Off the Grill</h3>
                <span class="event-time">July - September, 2025</span>
                <p>Enjoy the sizzling flavors of Grillhouse this season. Think juicy burgers, crispy sides, and chilled beers, all served fresh off the grill. A casual, satisfying dining spot for laid-back meals with friends and family.</p>
                <a href="/tac/tradewinds.php" class="cta-button primary">Learn More</a>
              </div>
            </div>
            <div class="card">
              <div class="events-image">
                <img src="/tac/images/home/events/thegourmetpantry.png">
              </div>
              <div class="events-info">
                <img src="/tac/images/home/brands/the-gourmet-pantry-logo.png">
                <h3>Cheese Selection</h3>
                <span class="event-time">July - September, 2025</span>
                <p>Discover our curated range of gourmet cheeses at The Gourmet Pantry. From soft and creamy to sharp and aged, there's something to suit every palate. Ideal for entertaining or indulging in a quiet moment of luxury.</p>
                <a href="/tac/tradewinds.php" class="cta-button primary">Learn More</a>
              </div>
            </div>
            <div class="card">  
              <div class="events-image">
                <img src="/tac/images/home/events/central.png">
              </div>
              <div class="events-info">
                <img src="/tac/images/home/brands/central-logo.png">
                <h3>Cream Burlee Latte</h3>
                <span class="event-time">July - September, 2025</span>
                <p>Introducing the new Cream Brûlée Latte at Central. This indulgent drink blends rich espresso, silky cream, and a torched caramelized topping. Perfect for a midday treat or your next coffee date.</p>
                <a href="/tac/tradewinds.php" class="cta-button primary">Learn More</a>
              </div>
            </div>
            <div class="card">  
              <div class="events-image">
                <img src="/tac/images/home/events/senspa.png">
              </div>
              <div class="events-info">
                <img src="/tac/images/home/brands/senspa-logo.png">
                <h3>Glow Up Your Skin</h3>
                <span class="event-time">July - September, 2025</span>
                <p>Treat your skin to a rejuvenating facial at sên Spa. Our seasonal Glow Up treatment is designed to restore radiance and hydration, leaving you glowing skin and ready to take on the day.</p>
                <a href="/tac/tradewinds.php" class="cta-button primary">Learn More</a>
              </div>
            </div>
            <div class="card">  
              <div class="events-image">
                <img src="/tac/images/home/events/thequad.png">
              </div>
              <div class="events-info">
                <img src="/tac/images/home/brands/thequad-logo.png">
                <h3>Endless Fun for Everyone</h3>
                <span class="event-time">July - September, 2025</span>
                <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam,</p>
                <a href="/tac/tradewinds.php" class="cta-button primary">Learn More</a>
              </div>
            </div>
          </div>
          <div class="mobile-events-carousel">
            <div class="carousel-track">
              <div class="carousel-slide">
                <div class="events-image">
                  <img src="/tac/images/home/events/tradewinds.png">
                </div>
                <div class="events-info">
                  <img src="/tac/images/home/brands/tradewinds.png">
                  <h3>Asian Delight Brunch</h3>
                  <span class="event-time">July - September, 2025</span>
                  <p>This Father's Day, raise a glass to Dad with bold cocktails and hearty dishes crafted for the occasion.</p>
                  <a href="/tac/tradewinds.php" class="cta-button primary">Learn More</a>
                </div>
              </div>
              <div class="carousel-slide">
                <div class="events-image">
                  <img src="/tac/images/home/events/the2ndfloor.png">
                </div>
                <div class="events-info">
                  <img src="/tac/images/home/brands/the-2nd-floor-logo.png">
                  <h3>Indulge in Romance</h3>
                  <span class="event-time">July - September, 2025</span>
                  <p>Large, artfully composed images of food and drinks, framed with thin gold borders or gold abstract lines, enhance the ambiance without overpowering it.</p>
                  <a href="/tac/tradewinds.php" class="cta-button primary">Learn More</a>
                </div>
              </div>
              <div class="carousel-slide">
                <div class="events-image">
                  <img src="/tac/images/home/events/grillhouse.png">
                </div>
                <div class="events-info">
                  <img src="/tac/images/home/brands/grillhouse-logo.png">
                  <h3>Always Fresh Off the Grill</h3>
                  <span class="event-time">July - September, 2025</span>
                  <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam,</p>
                  <a href="/tac/tradewinds.php" class="cta-button primary">Learn More</a>
                </div>
              </div>
              <div class="carousel-slide">
                <div class="events-image">
                  <img src="/tac/images/home/events/thegourmetpantry.png">
                </div>
                <div class="events-info">
                  <img src="/tac/images/home/brands/the-gourmet-pantry-logo.png">
                  <h3>Cheese Selection</h3>
                  <span class="event-time">July - September, 2025</span>
                  <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam,</p>
                  <a href="/tac/tradewinds.php" class="cta-button primary">Learn More</a>
                </div>
              </div>
              <div class="carousel-slide">
                <div class="events-image">
                  <img src="/tac/images/home/events/central.png">
                </div>
                <div class="events-info">
                  <img src="/tac/images/home/brands/central-logo.png">
                  <h3>Cream Burlee Latte</h3>
                  <span class="event-time">July - September, 2025</span>
                  <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam,</p>
                  <a href="/tac/tradewinds.php" class="cta-button primary">Learn More</a>
                </div>
              </div>
              <div class="carousel-slide">
                <div class="events-image">
                  <img src="/tac/images/home/events/senspa.png">
                </div>
                <div class="events-info">
                  <img src="/tac/images/home/brands/senspa-logo.png">
                  <h3>Glow Up Your Skin</h3>
                  <span class="event-time">July - September, 2025</span>
                  <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam,</p>
                  <a href="/tac/tradewinds.php" class="cta-button primary">Learn More</a>
                </div>
              </div>
              <div class="carousel-slide">
                <div class="events-image">
                  <img src="/tac/images/home/events/thequad.png">
                </div>
                <div class="events-info">
                  <img src="/tac/images/home/brands/thequad-logo.png">
                  <h3>Asian Delight Brunch</h3>
                  <span class="event-time">July - September, 2025</span>
                  <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam,</p>
                  <a href="/tac/tradewinds.php" class="cta-button primary">Learn More</a>
                </div>
              </div>
            </div>
            <div class="carousel-nav">
              <button class="nav-btn prev" aria-label="Previous event">
                <i class="fas fa-chevron-left"></i>
              </button>
              <button class="nav-btn next" aria-label="Next event">
                <i class="fas fa-chevron-right"></i>
              </button>
            </div>
            <div class="carousel-dots">
              <span class="carousel-dot active"></span>
              <span class="carousel-dot"></span>
              <span class="carousel-dot"></span>
              <span class="carousel-dot"></span>
              <span class="carousel-dot"></span>
              <span class="carousel-dot"></span>
              <span class="carousel-dot"></span>
            </div>
          </div>
        </div>
      </div>
    </section>

    <!-- Text Section 2 -->
    <section class="text-section text-section-2">
      <div class="container">
        <div class="content-wrapper">
          <h1 class="section-title" data-aos="fade-right" data-aos-duration="1000">Not Just A Club,<br>Your Community</h1>
          <p class="section-body"  data-aos="fade-up" data-aos-duration="1000" data-aos-delay="100">Being part of The American Club means more than access. It means connection. To people, to culture and to moments that matter.</p>
        </div>
      </div>
    </section>

    <!-- Features Section -->
    <section class="features-section">
      <div class="container">
        <div class="features-grid">
          <div class="feature-card why-members">
            <div class="feature-content">
              <h3 class="section-title">See Why Members Call It Home</h3>
              <p class="section-body">From world-class facilities to the warmth of our people, The American Club is designed to feel like home, yet unlike anywhere else.</p>
              <a href="#" class="cta-button secondary">Book A Tour</a>
            </div>
          </div>
          <div class="feature-card business-office">
            <div class="feature-content">
              <h3 class="section-title">Business & Office Spaces</h3>
              <p class="section-body">From focused solo work to client presentations, our business spaces provide everything you need with polished facilities and a calm space to get things done.</p>
              <a href="#" class="cta-button secondary">Learn More</a>
            </div>
          </div>
          <div class="feature-card home-family">
            <div class="feature-content">
              <h3 class="section-title">Home for the Whole Family</h3>
              <p class="section-body">With programmes, facilities, and experiences that bring the whole family together, The American Club is where cherished moments take root.</p>
              <a href="#" class="cta-button secondary">Learn More</a>
            </div>
          </div>
        </div>
      </div>
    </section>

    <!-- Footer -->
    <?php include 'footer.php'; ?>

    <script>
      gsap.registerPlugin(ScrollTrigger);

      gsap.to(".overlay-animation", {
        height: "130%", // covers hero + overlaps next section
        ease: "power3.out",
        scrollTrigger: {
          trigger: "#hero",
          start: "top top",
          end: "bottom top",
          scrub: 1,
          pin: true,
        }
      });
    </script>

  </body>
</html>