<!doctype html>
<html lang="en">
  <!-- Head -->
  <?php include 'head.php'; ?>
  
  <body class="tradewinds">
    <!-- Header -->
    <?php include 'header.php'; ?>

    <!-- Hero Banner Section -->
    <section class="banner" id="hero">
      <div class="overlay-animation tradewinds">
        <svg class="overlay-mask" viewBox="0 0 1440 150" preserveAspectRatio="none">
          <defs>
            <linearGradient id="overlayGradient" x1="0" y1="1" x2="0" y2="0">
              <stop offset="0%" stop-color="#8dc4c1" stop-opacity="1" />
              <stop offset="20%" stop-color="#8dc4c1" stop-opacity="1" />
              <stop offset="40%" stop-color="#8dc4c1" stop-opacity="0.8" />
              <stop offset="60%" stop-color="#8dc4c1" stop-opacity="0.6" />
              <stop offset="80%" stop-color="#8dc4c1" stop-opacity="0.3" />
              <stop offset="90%" stop-color="#8dc4c1" stop-opacity="0.1" />
              <stop offset="100%" stop-color="#8dc4c1" stop-opacity="0" />
            </linearGradient>
          </defs>
          <path d="M0,96 C360,192 1080,0 1440,96 L1440,0 L0,0 Z" fill="url(#overlayGradient)" />
        </svg>
      </div>
      <div class="banner-slider">
        <div class="banner-slide active">
          <img src="/tac/images/tradewinds/banner/tradewinds-hero.webp" alt="Banner Image 1">
        </div>
      </div>
      <div class="banner-content">
        <div class="banner-text">
          <p>A Global Table Awaits</p>
          <h1>Welcome to<br>Tradewinds</h1>
          <a href="/tac/wine-and-dine.php" class="cta-button secondary">Back to Wine & Dine</a>
        </div>
      </div>
      <button class="scroll-down-btn" aria-label="Scroll to next section">
        <i class="fa-solid fa-chevron-down"></i>
      </button>
    </section>

    <!-- Text Section 1 -->
    <section class="text-section text-section-1">
        <div class="container">
            <div class="brand-logo">
                <img src="/tac/images/home/brands/tradewinds.png" alt="Tradewinds Logo">
            </div>
            <div class="content-wrapper">
                <h1 class="section-title" data-aos="fade-right" data-aos-duration="1000">Inspired by the<br>Surface Winds</h1>
                <p class="section-body" data-aos="fade-up" data-aos-duration="1000" data-aos-delay="100">Let your palate set sail with bold, comforting flavours from across the world, served with timeless Club hospitality. Just as the trade winds once opened new worlds, this signature American Club restaurant brings diverse culinary cultures together in one harmonious menu. Each visit offers something familiar, and something unexpected.</p>
            </div>
        </div>

        <div class="container">
            <div class="details-wrapper">
                <div class="text-column">
                    <div class="decorative-line"></div>
                    <h4>Operating Hours</h4>
                    <div class="operating-hours-wrapper">
                        <div class="operating-hours" data-aos="fade-right" data-aos-duration="1000">
                            <p>
                                Sunday to Thursday<br><br>
                                8:00 A.M. – 9:00 P.M.<br>
                                (Last orders at 8:30 P.M.)
                            </p>
                        </div>

                        <div class="operating-hours" data-aos="fade-right" data-aos-duration="1000" data-aos-delay="200">
                            <p>
                                Friday & Saturday<br><br>
                                8:00 A.M. – 10:00 P.M.<br>
                                (Last orders at 9:30 P.M.)
                            </p>
                        </div>
                    </div>
                </div>

                <div class="text-column">
                  <div class="decorative-line"></div>
                  <h4>Location & Contact</h4>
                  <div data-aos="fade-right" data-aos-duration="1000" data-aos-delay="300">
                    <p>Level 1, Claymore Building</p>
                    <p><strong>T</strong> 6739-4361 &nbsp;&nbsp; <strong>E</strong> tradewinds@amclub.org.sg</p>
                    <p>Dress Code: Casual</p>
                  </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Text Section 2 -->
    <section class="text-section text-section-2">
      <div class="container">
        <div class="content-wrapper">
          <h1 class="section-title" data-aos="fade-right" data-aos-duration="1000">A World of Flavour,<br>Just Steps Away</h1>
          <p class="section-body" data-aos="fade-up" data-aos-duration="1000" data-aos-delay="100">Tradewinds brings the global dining experience home. Explore an ever-evolving selection of dishes that span continents, cultures, and cravings with its international menu offerings featuring nuanced flavors from America to Singapore.</p>
          <p class="section-body" data-aos="fade-up" data-aos-duration="1000" data-aos-delay="100">This restaurant takes its name from the prevailing surface winds – also known as trade winds – that blow predominantly from the northeast in the Northern Hemisphere and the southeast in the Southern Hemisphere. For centuries, trade winds have facilitated ships to cross the world's oceans, establishing trade routes across the Atlantic and Paciﬁc oceans.</p>
          <p class="section-body" data-aos="fade-up" data-aos-duration="1000" data-aos-delay="100">Tradewinds brings the world's flavors to The American Club table.</p>
          <p class="section-body" data-aos="fade-up" data-aos-duration="1000" data-aos-delay="100"><strong>Wine Corkage Policy</strong><br>Enjoy complimentary corkage with every bottle purchased from our restaurants. Standard corkage is $20 per bottle.</p>
        </div>
      </div>
    </section>

    <section class="gallery-section">
      <div class="container">
        <div class="splide gallery-splide">
          <div class="splide__track">
            <ul class="splide__list">
              <li class="splide__slide">
                <div class="gallery-image">
                  <img src="/tac/images/tradewinds/gallery-1.png" alt="Restaurant Image">
                </div>
              </li>
              <li class="splide__slide">
                <div class="gallery-image">
                  <img src="/tac/images/tradewinds/gallery-2.png" alt="Restaurant Image">
                </div>
              </li>
              <li class="splide__slide">
                <div class="gallery-image">
                  <img src="/tac/images/tradewinds/gallery-3.png" alt="Restaurant Image">
                </div>
              </li>
            </ul>
          </div>
        </div>
        <div class="gallery-buttons">
          <a href="#" class="cta-button primary">Book a Table</a>
          <a href="#" class="cta-button primary">Menu</a>
          <a href="#" class="cta-button primary">360 view</a>
        </div>
      </div>
    </section>

    <section class="text-section text-section-2">
        <div class="container">
            <div class="content-wrapper">
                <h1 class="section-title" data-aos="fade-right" data-aos-duration="1000">Promotions</h1>
                <p class="section-body" data-aos="fade-up" data-aos-duration="1000" data-aos-delay="100">Explore our limited-time dishes and dining promotions, specially crafted to enhance your dining experience.</p>
            </div>
        </div>
    </section>

    <!-- Promotions Section -->
    <section class="promotions-section" id="promotions">
      <div class="container">
        <div class="splide promotions-splide">
          <div class="splide__track">
            <ul class="splide__list">
              <li class="splide__slide">
                <div class="promotion-card">
                  <div class="promotion-image">
                    <img src="/tac/images/tradewinds/asian-delight.png" alt="Asian Delight">
                  </div>
                </div>
              </li>
              <li class="splide__slide">
                <div class="promotion-card">
                  <div class="promotion-image">
                    <img src="/tac/images/tradewinds/singapore-local.png" alt="Singapore Local Flavors">
                  </div>
                </div>
              </li>
              <li class="splide__slide">
                <div class="promotion-card">
                  <div class="promotion-image">
                    <img src="/tac/images/tradewinds/sunday-brunch-01.png" alt="Sunday Brunch">
                  </div>
                </div>
              </li>
              <li class="splide__slide">
                <div class="promotion-card">
                  <div class="promotion-image">
                  <img src="/tac/images/home/services/wine-and-dine.webp" alt="Wine and Dining">
                  </div>
                </div>
              </li>
              <li class="splide__slide">
                <div class="promotion-card">
                  <div class="promotion-image">
                  <img src="/tac/images/home/services/wine-and-dine.webp" alt="Wine and Dining">
                  </div>
                </div>
              </li>
              <li class="splide__slide">
                <div class="promotion-card">
                  <div class="promotion-image">
                  <img src="/tac/images/home/services/wine-and-dine.webp" alt="Wine and Dining">
                  </div>
                </div>
              </li>
            </ul>
          </div>
        </div>
      </div>
    </section>

    <section class="bottom-bg-section">
      <div class="container"></div>
    </section>

    <!-- Footer -->
    <?php include 'footer.php'; ?>

    <script>
      document.addEventListener('DOMContentLoaded', function() {
        if (typeof Splide !== 'undefined') {
          // Initialize promotions carousel
          new Splide('.promotions-splide', {
            type: 'loop',
            perPage: 3,
            perMove: 1,
            gap: '2rem',
            pagination: false,
            arrows: true,
            autoplay: true,
            interval: 4000,
            pauseOnHover: true,
            pauseOnFocus: true,
            breakpoints: {
              768: {
                perPage: 1,
              }
            },
            classes: {
              arrows: 'splide__arrows',
              arrow: 'splide__arrow',
              prev: 'splide__arrow--prev',
              next: 'splide__arrow--next'
            }
          }).mount();

          // Initialize gallery carousel
          new Splide('.gallery-splide', {
            type: 'loop',
            perPage: 3,
            perMove: 1,
            focus: 'center',
            gap: '6rem',
            flickMaxPages: 1,
            pagination: false,
            arrows: false,
            autoplay: true,
            interval: 4000,
            pauseOnHover: true,
            pauseOnFocus: true,
            drag: true,
            snap: true,
            trimSpace: true,
            breakpoints: {
              768: {
                perPage: 1,
              }
            }
          }).mount();
        } else {
          console.error('Splide library not loaded');
        }
      });

      gsap.registerPlugin(ScrollTrigger);

      gsap.to(".overlay-animation.tradewinds", {
        height: "130%", // covers hero + overlaps next section
        ease: "power3.out",
        scrollTrigger: {
          trigger: "#hero",
          start: "top top",
          end: "bottom top",
          scrub: 0.5,
          pin: true,
          anticipatePin: 1,
          fastScrollEnd: true,
          preventOverlaps: true
        }
      });
    </script>

  </body>
</html>