<!doctype html>
<html lang="en">
  <!-- Head -->
  <?php include 'head.php'; ?>
  
  <body class="wine-and-dine">
    <!-- Header -->
    <?php include 'header.php'; ?>

    <!-- Hero Banner Section -->
    <section class="banner" id="hero">
      <div class="banner-slider">
        <div class="banner-slide active">
          <img src="/tac/images/wine-and-dine/banner/wine-and-dine-hero.webp" alt="Banner Image 1">
        </div>
      </div>
      <div class="banner-content">
        <div class="banner-text">
          <p>Countless Ways to Dine, Drink, Snack, & Socialize</p>
          <h1>Wine & Dine</h1>
          <a href="#" class="cta-button secondary">Back To Home</a>
        </div>
      </div>
      <button class="scroll-down-btn" aria-label="Scroll to next section">
        <i class="fa-solid fa-chevron-down"></i>
      </button>
    </section>

    <!-- Poster Section -->
    <section class="poster-section">
      <div class="container">
        <div class="content-wrapper central">
          <div class="poster-content">
            <div class="poster-text dark">
              <img src="/tac/images/home/brands/central-logo.png" alt="Central Logo">
              <p>Your daily go-to for a great coffee, freshly made sandwiches, and friendly conversation. Casual, convenient, and always welcoming.</p>
              <h3>Level 1, Scotts Road Building</h3>
              <a href="/tac/tradewinds.php" class="cta-button primary">Learn More</a>
            </div>
          </div>
          <div class="poster-image">
            <img src="/tac/images/wine-and-dine/central.png" alt="Central">
          </div>
        </div>

        <div class="content-wrapper grillhouse right">
          <div class="poster-image">
            <img src="/tac/images/wine-and-dine/grillhouse.png" alt="Grillhouse">
          </div>
          <div class="poster-content">
            <div class="poster-text white">
              <img src="/tac/images/home/brands/grillhouse-logo-white.png" alt="Grillhouse Logo">
              <p>Fire up your appetite at the Grillhouse, with American BBQ, wood-fired pizza, and cold beer in a breezy, poolside setting.</p>
              <h3>Level 1, Adjacent to The Pool</h3>
              <a href="/tac/tradewinds.php" class="cta-button secondary">Learn More</a>
            </div>
          </div>
        </div>

        <div class="content-wrapper the2ndfloor">
          <div class="poster-content">
            <div class="poster-text white">
              <img src="/tac/images/home/brands/the-2nd-floor-logo.png" alt="The 2nd Floor Logo">
              <p>An elevated dining experience where East meets West, and fine ingredients and refined technique come together.</p>
              <h3>Level 2, Claymore building</h3>
              <a href="/tac/tradewinds.php" class="cta-button secondary">Learn More</a>
            </div>
          </div>
          <div class="poster-image">
            <img src="/tac/images/wine-and-dine/the2ndfloor.png" alt="The 2nd Floor">
          </div>
        </div>

        <div class="content-wrapper tradewinds right">
          <div class="poster-image">
            <img src="/tac/images/wine-and-dine/tradewinds.png" alt="Tradewinds">
          </div>
          <div class="poster-content">
            <div class="poster-text dark">
              <img src="/tac/images/home/brands/tradewinds.png" alt="Grillhouse Logo">
              <p>Global flavours take the spotlight at this beloved dining destination with international fare.</p>
              <h3>Level 1, Claymore Building</h3>
              <a href="/tac/tradewinds.php" class="cta-button primary">Learn More</a>
            </div>
          </div>
        </div>

        <div class="content-wrapper thegourmetpantry">
          <div class="poster-content">
            <div class="poster-text white">
              <img src="/tac/images/home/brands/the-gourmet-pantry-logo-white-03.png" alt="The Gourmet Pantry Logo">
              <p>Bring the Club experience home. Curated wines, gourmet treats, exclusive Club merchandise, and more, all in one delicious stop.</p>
              <h3>Level 1, The Lobby</h3>
              <a href="/tac/tradewinds.php" class="cta-button secondary">Learn More</a>
            </div>
          </div>
          <div class="poster-image">
            <img src="/tac/images/wine-and-dine/thegourmetpantry.png" alt="Central">
          </div>
        </div>

      </div>
    </section>

    <!-- Text Section -->
    <section class="text-section text-section-2">
      <div class="container">
        <div class="content-wrapper">
          <h1 class="section-title">Your Next Bite Awaits</h1>
          <p class="section-body">Each of our restaurants offers its own unique flavour and setting. Take a tour and taste your way through The American Club.</p>
        </div>
      </div>
    </section>

    <!-- Features Section -->
    <section class="features-section">
      <div class="container">
        <div class="features-grid">
          <div class="feature-card catering">
            <div class="feature-content">
              <h3 class="section-title">Events & Catering</h3>
              <p class="section-body">With full-service catering and our stunning Galbraith ballroom, your next event begins here.</p>
              <a href="#" class="cta-button secondary">Learn More</a>
            </div>
          </div>
          <div class="feature-card bottles2go">
            <div class="feature-content">
              <h3 class="section-title">Bottles2Go!</h3>
              <p class="section-body">Explore our handpicked wine selection online, and have your wines delivered straight to your door.</p>
              <a href="#" class="cta-button secondary">Order Here</a>
            </div>
          </div>
          <div class="feature-card tac2go">
            <div class="feature-content">
              <h3 class="section-title">TAC2Go!</h3>
              <p class="section-body">Bringing your go-to Club dishes to your doorstep, hot, fresh, and ready to enjoy.</p>
              <a href="#" class="cta-button secondary">Order Here</a>
            </div>
          </div>
        </div>
      </div>
    </section>
    
    <!-- Footer -->
    <?php include 'footer.php'; ?>

  </body>
</html>